/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.notice.cluster.SetFrequentStatusRefreshPeriodNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class TerminateInstanceAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final String instanceId;

    @JsonCreator
    public TerminateInstanceAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="instanceId") String instanceId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.instanceId = instanceId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Preconditions.checkArgument((this.instanceId != null ? 1 : 0) != 0, (Object)"[instanceId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        this.getToolbox().getNodeHelper().restartNode(cluster, this.instanceId);
        this.getToolbox().getNoticeManager().queueNotice(new SetFrequentStatusRefreshPeriodNotice(this.getToolbox(), cluster), true);
        this.getToolbox().getClusterStackHelper().refreshClusterDetails(this.clusterId);
        return ImmutableMap.of((Object)"clusterId", (Object)this.clusterId, (Object)"instanceId", (Object)this.instanceId);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("instanceId", (Object)this.instanceId).append("context", this.getContext()).toString();
    }
}

