/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class SwitchToHardUpdateAction
extends ClusterAuthenticatedAction {
    private final String clusterId;

    @JsonCreator
    public SwitchToHardUpdateAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        Info existingInfo = this.getToolbox().getEntityStateDataManager().get(cluster);
        SwitchToHardUpdateAction.validateState(existingInfo);
        this.getToolbox().getNoticeManager().queueNoticeAndAwaitCompletion(new SwitchToHardUpdateNotice(this.getToolbox(), existingInfo), true, 20000L);
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("context", this.getContext()).toString();
    }

    private static void validateState(Info info) {
        if (!UpdateType.ROLLING.equals((Object)info.getUpdateType())) {
            throw new IAE("SwitchToHardUpdateAction can only be called during a ROLLING type update", new Object[0]);
        }
        if (!State.CLUSTER_ROLLING_UPDATE_IN_PROGRESS.equals((Object)info.getState())) {
            throw new IAE("SwitchToHardUpdateAction can only be performed after the rolling update has been planned and while it is executing", new Object[0]);
        }
        if (info.getUpdateState() == null || info.getUpdateState().getPendingRollingStages() == null) {
            throw new ISE("Can't retrieve update state for cluster [%s]", new Object[]{info.getEntityId()});
        }
        if (info.getUpdateState().getSupportedTypes() == null || !info.getUpdateState().getSupportedTypes().contains(UpdateType.HARD)) {
            throw new IAE("Current update cannot be switched to a [HARD] UpdateType", new Object[0]);
        }
    }

    public static class SwitchToHardUpdateNotice
    extends OperationsNotice {
        private SwitchToHardUpdateNotice(ManagerToolbox toolbox, Info info) {
            super(toolbox, info);
        }

        @Override
        protected void innerHandle() {
            SwitchToHardUpdateAction.validateState(this.info);
            UpdateState.Builder updateStateBuilder = UpdateState.builder((UpdateState)this.info.getUpdateState()).type(UpdateType.HARD).pendingRollingStages(this.toolbox.getStageHelper().convertRollingToHardUpdate(this.info.getUpdateState().getPendingRollingStages())).clearTimerAndCounters();
            this.toolbox.getEntityStateDataManager().insert(this.info, Info.builder().withUpdateState(updateStateBuilder.build()).withUpdateType(UpdateType.HARD).build());
            this.addInfoNotification("Remainder of update re-planned as a non-rolling update", new Object[0]);
        }
    }
}

