/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RestartClusterAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final UpdateType updateType;

    @JsonCreator
    public RestartClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="restartType") UpdateType updateType, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.updateType = updateType;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.updateType != null ? 1 : 0) != 0, (Object)"[restartType] required");
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        Info info = this.getToolbox().getEntityStateDataManager().get(cluster);
        if (!State.CLUSTER_RESTART_REQUEST_RECEIVED.getValidPreviousStates().contains(info.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{cluster.getClusterId(), info.getState(), State.CLUSTER_RESTART_REQUEST_RECEIVED, State.CLUSTER_RESTART_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        ArrayList possibleUpdateTypes = Lists.newArrayList();
        possibleUpdateTypes.add(UpdateType.HARD);
        if (this.getToolbox().getClusterUpdateHelper().canSupportRollingUpdates(cluster)) {
            possibleUpdateTypes.add(UpdateType.ROLLING);
        }
        if (possibleUpdateTypes.stream().noneMatch(x -> x.equals((Object)this.updateType))) {
            throw new IAE("restartType [%s] is not supported for this cluster", new Object[]{this.updateType});
        }
        Info.Builder updateInfoBuilder = this.getDefaultInfoBuilder(cluster).withState(State.CLUSTER_RESTART_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATED).withUpdateType(this.updateType).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateState(UpdateState.builder().currentState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).supportedTypes((List)possibleUpdateTypes).build()).clearExistingUpdateState();
        ClusterWithExtendedInfo updatedClusterWithInfo = this.getToolbox().getClusterDataManager().updateWithInfo(cluster, updateInfoBuilder.build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), true, true, false, false, true);
        this.clearAllNotifications(updatedClusterWithInfo.getCluster().key());
        this.addInfoNotification(updatedClusterWithInfo.getCluster().key(), "Cluster restart requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(updatedClusterWithInfo.getExtendedInfo().getInfo());
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }
}

