/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.manager.stage.AwaitAgentReplacementStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.util.IAE;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class NotifyAgentReplacedAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final String original;
    private final String replacement;

    @JsonCreator
    public NotifyAgentReplacedAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="original") String original, @JsonProperty(value="replacement") String replacement, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.original = original;
        this.replacement = replacement;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Preconditions.checkArgument((this.original != null ? 1 : 0) != 0, (Object)"[original] required");
        Preconditions.checkArgument((this.replacement != null ? 1 : 0) != 0, (Object)"[replacement] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        Info info = this.getToolbox().getEntityStateDataManager().get(cluster);
        NotifyAgentReplacedAction.validateState(info);
        this.getToolbox().getNoticeManager().queueNoticeAndAwaitCompletion(new NotifyAgentReplacedNotice(this.getToolbox(), info, this.original, this.replacement), true, 20000L);
        return null;
    }

    private static void validateState(Info info) {
        if (!State.CLUSTER_AGENT_UPDATE_IN_PROGRESS.equals((Object)info.getState())) {
            throw new IAE("Agent update is not in progress, [%s]", new Object[]{info.getState()});
        }
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.ONPREM);
    }

    public static class NotifyAgentReplacedNotice
    extends OperationsNotice {
        private final String original;
        private final String replacement;

        private NotifyAgentReplacedNotice(ManagerToolbox toolbox, Info info, String original, String replacement) {
            super(toolbox, info);
            this.original = original;
            this.replacement = replacement;
        }

        @Override
        protected void innerHandle() {
            NotifyAgentReplacedAction.validateState(this.info);
            Deque pendingStages = this.info.getUpdateState().getPendingRollingStages();
            if (pendingStages.isEmpty() || !(pendingStages.getFirst() instanceof AwaitAgentReplacementStage)) {
                throw new IAE("Agent is not ready to update.", new Object[0]);
            }
            AwaitAgentReplacementStage stage = (AwaitAgentReplacementStage)pendingStages.getFirst();
            if (!this.original.equals(stage.getHost())) {
                throw new IAE("Agent [%s] is not ready to update, [%s] is", new Object[]{this.original, stage.getHost()});
            }
            stage.setReplacement(this.replacement);
            this.toolbox.getEntityStateDataManager().insert(this.info, Info.builder().withUpdateState(this.info.getUpdateState()).build());
        }
    }
}

