/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.User;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class DescribeClustersByAccountAction
extends AuthenticatedAction {
    private final boolean simple;

    @JsonCreator
    public DescribeClustersByAccountAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="simple") Boolean simple, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal);
        this.simple = BooleanUtils.isTrue((Boolean)simple);
    }

    @Override
    public Object innerPerform() {
        HashMap<String, List> accountClusterMap = new HashMap<String, List>();
        for (Cluster cluster : this.getToolbox().getClusterDataManager().getAll()) {
            accountClusterMap.compute(cluster.getAccountId(), (k, v) -> {
                Cluster myCluster = cluster.cloner().withSensitiveFieldsMasked().build();
                if (v == null) {
                    return new ArrayList<Cluster>(Collections.singletonList(this.simple ? myCluster.simplifiedForBilling() : myCluster));
                }
                v.add(this.simple ? myCluster.simplifiedForBilling() : myCluster);
                return v;
            });
        }
        return accountClusterMap;
    }

    @Override
    public boolean isAuthorized(User principal) {
        return false;
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public Collection<String> getAccountIds() {
        return ImmutableList.of();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("simple", this.simple).append("context", this.getContext()).toString();
    }
}

