/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.model.User;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;

public class DescribeClusterUpdateAction
extends ClusterAuthenticatedAction {
    private final Cluster cluster;

    @JsonCreator
    public DescribeClusterUpdateAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="cluster") Cluster cluster, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, cluster != null ? cluster.getClusterId() : null);
        this.cluster = cluster != null ? cluster.cloner().withSensitiveFieldPlaceholdersRemoved().build() : null;
    }

    @Override
    public Object innerPerform() {
        boolean onlyInformationalFieldsChanged;
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        Preconditions.checkArgument((this.cluster.getClusterId() != null ? 1 : 0) != 0, (Object)"[cluster.clusterId] required");
        Info info = this.getToolbox().getEntityStateDataManager().get(this.cluster);
        Cluster originalCluster = this.getToolbox().getClusterDataManager().get(this.cluster.getClusterId());
        if (this.cluster.getAccountId() != null && !this.cluster.getAccountId().equals(originalCluster.getAccountId())) {
            throw new IAE("Update failed for cluster [%s]: accountId cannot be modified", new Object[]{this.cluster.getClusterId()});
        }
        Account account = this.getToolbox().getAccountDataManager().get(originalCluster.getAccountId());
        Cluster clusterWithUpdatableFields = this.cluster.cloner().withoutNonUpdatableFields().withImplyVersionFull(this.cluster.getImplyVersionFull() != null ? this.cluster.getImplyVersionFull() : this.getToolbox().getImplyVersionHelper().lookupImplyVersionIncludingAccountVersions(this.cluster.getImplyVersion(), this.cluster.getAccountId(), this.getToolbox().getClusterDataManager())).build();
        Cluster diffCluster = clusterWithUpdatableFields.mergeDiff(originalCluster);
        Cluster mergedCluster = originalCluster.cloner().withCluster(clusterWithUpdatableFields, true).withDefaultsForUnset(this.getToolbox().getApplicationConfig(), false, this.getToolbox().getInstanceTypeHelper()).build();
        boolean bl = onlyInformationalFieldsChanged = !diffCluster.isEmpty() && diffCluster.cloner().withName(null).withMetadata(null).withComments(null).build().isEmpty();
        if (!onlyInformationalFieldsChanged) {
            mergedCluster.validate(account, (Toolbox)this.getToolbox(), false);
        }
        this.handleMagicTags(mergedCluster, this.getContext());
        int proposedTotalMICU = this.getToolbox().getClusterUpdateHelper().getTotalMICU(account.getAccountId(), info.getState() != null && info.getState().isRunning() ? mergedCluster : null);
        Info.Builder infoBuilder = this.getDefaultInfoBuilder(originalCluster);
        if (account.isValueExceedingIcuLimit(proposedTotalMICU)) {
            infoBuilder.withAvailableUpdateTypes((List)ImmutableList.of((Object)new UpdateDetails(UpdateType.UNSUPPORTED, null, String.format("Cluster update not possible: ICU limit of [%d] would be exceeded", account.getIcuLimit()))));
        } else {
            infoBuilder.withAvailableUpdateTypes(this.getToolbox().getClusterUpdateHelper().getUpdateDetailsForClusterDiff(diffCluster, originalCluster));
        }
        return ClusterWithExtendedInfo.build((Cluster)diffCluster, (ExtendedInfo)ExtendedInfo.of((Info)infoBuilder.build()), (boolean)true);
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        Preconditions.checkArgument((this.cluster.getClusterId() != null ? 1 : 0) != 0, (Object)"[cluster.clusterId] required");
        return super.isAuthorized(principal);
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cluster", (Object)this.cluster).append("context", this.getContext()).toString();
    }
}

