/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.action.cluster.DescribeClusterUpdateAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import java.util.Objects;

public class DescribeClusterRevertAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final Integer version;

    @JsonCreator
    public DescribeClusterRevertAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="version") Integer version, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.version = version;
    }

    @Override
    protected Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Preconditions.checkArgument((this.version != null ? 1 : 0) != 0, (Object)"[version] required");
        Cluster deployedCluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        Integer latestVersion = deployedCluster.getVersion();
        if (Objects.equals(latestVersion, this.version)) {
            throw new IAE("Cluster revert not possible, version [%s] is the latest", new Object[]{this.version});
        }
        Cluster revertToCluster = this.getToolbox().getClusterDataManager().getVersionOrNull(this.clusterId, this.version.intValue());
        if (revertToCluster == null) {
            throw new IAE("Cluster revert not possible, version [%s] not found", new Object[]{this.version});
        }
        DescribeClusterUpdateAction describeClusterUpdateAction = new DescribeClusterUpdateAction(this.getToolbox(), revertToCluster, this.getContext(), this.getPrincipalId());
        return describeClusterUpdateAction.innerPerform();
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("version", (Object)this.version).append("context", this.getContext()).toString();
    }
}

