/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class ClearNotificationsAction
extends ClusterAuthenticatedAction {
    private final String clusterId;

    @JsonCreator
    public ClearNotificationsAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        this.clearAllNonCriticalNotifications(cluster.key());
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("context", this.getContext()).toString();
    }
}

