/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AccountWithExtendedInfo;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DescribeAccountsAction
extends AuthenticatedAction {
    private final Boolean showDeleted;

    @JsonCreator
    public DescribeAccountsAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="showDeleted") Boolean showDeleted, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal);
        this.showDeleted = showDeleted;
    }

    @Override
    public Object innerPerform() {
        List accounts = this.getToolbox().getAccountDataManager().getAll(this.showDeleted == null || this.showDeleted == false ? DeletedVisibility.HIDE : DeletedVisibility.SHOW_ALL);
        List accountWithExtendedInfos = accounts.stream().map(x -> AccountWithExtendedInfo.build((Account)x.cloner().withSensitiveFieldsMasked().build(), (ExtendedInfo)ExtendedInfo.of((Info)this.getToolbox().getEntityStateDataManager().get(x)), (boolean)true)).collect(Collectors.toList());
        return ImmutableMap.of((Object)"accounts", accountWithExtendedInfos);
    }

    @Override
    public boolean isAuthorized(User principal) {
        return false;
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    @Override
    public Collection<String> getAccountIds() {
        return ImmutableList.of();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("context", this.getContext()).toString();
    }
}

