/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.usage.UsageReport;
import io.imply.cloud.model.usage.UsageReportClusterEntry;
import io.imply.cloud.model.usage.UsageReportIntervalEntry;
import io.imply.cloud.model.usage.UsageReportIntervalReport;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class DescribeAccountUsageAction
extends AccountAuthenticatedAction {
    private static final Logger log = new Logger(DescribeAccountUsageAction.class);
    private final String accountId;
    private final Interval interval;
    private final List<String> clusterFilter;

    @JsonCreator
    public DescribeAccountUsageAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="clusterFilter") List<String> clusterFilter, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
        this.interval = interval;
        this.clusterFilter = clusterFilter;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        Account account = this.getToolbox().getAccountDataManager().get(this.accountId);
        this.handleMagicTags(account, this.getContext());
        return new UsageReport(this.accountId, DateTime.now(), this.getCurrentClusterUsage(this.accountId), this.interval == null ? null : new UsageReportIntervalReport(this.interval, this.getToolbox().getAccountUsageHelper().getIntervalClusterUsage(this.accountId, this.interval, this.clusterFilter)));
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("interval", (Object)this.interval).append("clusterFilter", this.clusterFilter).toString();
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS);
    }

    private List<UsageReportClusterEntry> getCurrentClusterUsage(String accountId) {
        List clusters = this.getToolbox().getClusterDataManager().getAllWithAccountId(accountId);
        if (clusters == null) {
            return ImmutableList.of();
        }
        ArrayList<UsageReportClusterEntry> currentClusterUsage = new ArrayList<UsageReportClusterEntry>();
        for (Cluster cluster : clusters) {
            if (this.clusterFilter != null && !this.clusterFilter.contains(cluster.getClusterId())) continue;
            Info clusterInfo = this.getToolbox().getEntityStateDataManager().get(cluster);
            if (clusterInfo == null || clusterInfo.getState() == null) {
                log.error("Unable to get entity state for cluster [%s]; not including in usage report", new Object[]{cluster.getClusterId()});
                continue;
            }
            if (!clusterInfo.getState().isRunning()) continue;
            DateTime nowHour = DateTime.now().hourOfDay().roundFloorCopy();
            UsageReportIntervalEntry intervalEntry = new UsageReportIntervalEntry(new Interval((ReadableInstant)nowHour, (ReadablePeriod)Period.hours((int)1)), this.getToolbox().getAccountUsageHelper().generateUsageReportNodeMap(cluster));
            currentClusterUsage.add(new UsageReportClusterEntry(cluster.getClusterId(), cluster.getName(), (List)ImmutableList.of((Object)intervalEntry), null));
        }
        return currentClusterUsage;
    }
}

