/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.grove.GroveAgentUtil;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Platform;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.server.ApplicationNode;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;

public class DescribeAccountResourcesAction
extends AccountAuthenticatedAction {
    private static final Logger log = new Logger(DescribeAccountResourcesAction.class);
    private final String accountId;
    private final boolean unusedOnly;
    private final boolean showUnmodifiable;

    @JsonCreator
    public DescribeAccountResourcesAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="unusedOnly") Boolean unusedOnly, @JsonProperty(value="showUnmodifiable") Boolean showUnmodifiable, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
        this.unusedOnly = BooleanUtils.isTrue((Boolean)unusedOnly);
        this.showUnmodifiable = BooleanUtils.isTrue((Boolean)showUnmodifiable);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        Account account = this.getToolbox().getAccountDataManager().get(this.accountId);
        this.handleMagicTags(account, this.getContext());
        Preconditions.checkArgument((account.getGroveServer() != null ? 1 : 0) != 0, (String)"No [groveServer] configuration found for accountId [%s]", (Object)this.accountId);
        List nodes = this.getToolbox().getGroveClient().getGroveNodes(account.getGroveServer(), true);
        if (!this.getToolbox().getManagerConfig().isIncludeSelfAsAgent()) {
            ArrayList<String> hostnameAndAddressExclusions = new ArrayList<String>(this.getToolbox().getApplicationNode().getAllAddresses());
            hostnameAndAddressExclusions.add(this.getToolbox().getApplicationNode().getHost());
            hostnameAndAddressExclusions.add(ApplicationNode.getDefaultHost());
            log.debug("Excluding hosts from list of available nodes: %s", new Object[]{hostnameAndAddressExclusions});
            nodes = nodes.stream().filter(x -> !hostnameAndAddressExclusions.contains(x.getAddress()) && !hostnameAndAddressExclusions.contains(x.getHostname())).collect(Collectors.toList());
        }
        nodes = GroveAgentUtil.augmentNodesWithClusterInfo((ClusterDataManager)this.getToolbox().getClusterDataManager(), (EntityStateDataManager)this.getToolbox().getEntityStateDataManager(), (ClusterNodesHelper)this.getToolbox().getClusterNodesHelper(), (List)nodes);
        Stream<Object> nodesStream = nodes.stream();
        if (this.unusedOnly) {
            nodesStream = nodesStream.filter(x -> x.isAvailable() != null && x.isAvailable() != false);
        }
        if (!this.showUnmodifiable) {
            nodesStream = nodesStream.filter(Node::isModifiable);
        }
        return ImmutableMap.of((Object)"nodes", nodesStream.collect(Collectors.toList()));
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.ONPREM);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }
}

