/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;

public class DeleteAccountAction
extends AccountAuthenticatedAction {
    private final String accountId;

    @JsonCreator
    public DeleteAccountAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = accountId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        Account account = this.getToolbox().getAccountDataManager().get(this.accountId);
        this.handleMagicTags(account, this.getContext());
        if (Boolean.parseBoolean(this.getContext().get("deleteUsers"))) {
            this.getToolbox().getUserDataManager().getAllWithAccountId(this.accountId).forEach(x -> this.getToolbox().getUserDataManager().delete(x.getUserId(), ThreadLocalContext.getPrincipal().getDetailedUserId()));
        }
        this.checkIfDeleteIsPossible();
        Info infoToInsert = this.getToolbox().getEntityStateDataManager().insert(account, this.getDefaultInfoBuilder(account).withState(State.ACCOUNT_DELETE_REQUEST_RECEIVED).withDesiredState(State.ACCOUNT_DELETED).build());
        this.clearAllNotifications(account.key());
        this.addInfoNotification(account.key(), "Account deletion requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(infoToInsert);
        return ImmutableMap.of((Object)"accountId", (Object)account.getAccountId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS, (Object)Platform.SAAS);
    }

    private void checkIfDeleteIsPossible() {
        if (!this.getToolbox().getClusterDataManager().getAllWithAccountId(this.accountId).isEmpty()) {
            throw new IAE("Cannot delete account [%s] which has clusters", new Object[]{this.accountId});
        }
        if (!this.toolbox.getApplicationConfig().isSaaS() && !this.getToolbox().getUserDataManager().getAllWithAccountId(this.accountId).isEmpty()) {
            throw new IAE("Cannot delete account [%s] which has users", new Object[]{this.accountId});
        }
    }
}

