/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;

public class CreateAccountNetworkStackAction
extends AccountAuthenticatedAction {
    private final String accountId;

    @JsonCreator
    public CreateAccountNetworkStackAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = accountId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        Account account = this.getToolbox().getAccountDataManager().get(this.accountId);
        this.handleMagicTags(account, this.getContext());
        Info existingInfo = this.getToolbox().getEntityStateDataManager().getOrNull(account);
        if (existingInfo != null && existingInfo.hasNetworkStack()) {
            throw new IAE("Account [%s] is already associated with a network stack. Delete the stack first by calling deleteAccountNetworkStack", new Object[]{this.accountId});
        }
        Info info = this.getToolbox().getEntityStateDataManager().insert(account, this.getDefaultInfoBuilder(account).withState(State.ACCOUNT_INFO_RECEIVED).withDesiredState(State.ACCOUNT_CREATED).build());
        this.clearAllNotifications(account.key());
        this.addInfoNotification(account.key(), "Account network stack creation requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(info);
        return ImmutableMap.of((Object)"accountId", (Object)this.accountId);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS);
    }
}

