/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AccountWithExtendedInfo;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class CreateAccountAction
extends AuthenticatedAction {
    private final Account account;
    private final boolean allowDuplicateRole;

    @JsonCreator
    public CreateAccountAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="account") Account account, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal, @JsonProperty(value="allowDuplicateRole") Boolean allowDuplicateRole) {
        super(toolbox, context, principal);
        this.account = account;
        this.allowDuplicateRole = BooleanUtils.isTrue((Boolean)allowDuplicateRole);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.account != null ? 1 : 0) != 0, (Object)"[account] required");
        if (this.account.getAccountId() != null) {
            Preconditions.checkArgument((this.toolbox.getAccountDataManager().getOrNull(this.account.getAccountId()) == null ? 1 : 0) != 0, (Object)"[account.accountId] must be unique.");
        }
        Account accountToCreate = this.account.cloner().withDefaultsForUnset().withoutNonUpdatableFields().build();
        accountToCreate.validate(true, this.allowDuplicateRole, this.getToolbox().getAccountDataManager().getAll(DeletedVisibility.HIDE), this.toolbox.getRefreshableConstants());
        this.handleMagicTags(accountToCreate, this.getContext());
        boolean isMock = !Constants.hasMagicRealTag((String)accountToCreate.getName()) && (Constants.hasMagicMockTag((String)accountToCreate.getName()) || this.getToolbox().getApplicationConfig().isUseMocks());
        AccountWithExtendedInfo createdAccountWithInfo = this.getToolbox().getAccountDataManager().createWithInfo(accountToCreate, this.getDefaultInfoBuilder(accountToCreate).withState(State.ACCOUNT_INFO_RECEIVED).withDesiredState(State.ACCOUNT_CREATED).withMockEntity(Boolean.valueOf(isMock)).build(), ThreadLocalContext.getPrincipal().getDetailedUserId());
        this.clearAllNotifications(createdAccountWithInfo.getAccount().key());
        this.addInfoNotification(createdAccountWithInfo.getAccount().key(), "Account creation requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(createdAccountWithInfo.getExtendedInfo().getInfo());
        return ImmutableMap.of((Object)"accountId", (Object)createdAccountWithInfo.getAccount().getAccountId());
    }

    @Override
    public boolean isAuthorized(User principal) {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("account", (Object)this.account).append("context", this.getContext()).toString();
    }

    @Override
    public Collection<String> getAccountIds() {
        return ImmutableList.of();
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS, (Object)Platform.SAAS);
    }
}

