/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.User;
import java.util.Collection;
import java.util.Map;

public abstract class AccountAuthenticatedAction
extends AuthenticatedAction {
    @JsonProperty
    private final String accountId;

    public AccountAuthenticatedAction(ManagerToolbox toolbox, Map<String, String> context, String principal, String accountId) {
        super(toolbox, context, principal);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
    }

    @Override
    public Collection<String> getAccountIds() {
        return this.accountId == null ? null : ImmutableList.of((Object)this.accountId);
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        return principal.getAccountIds().contains(this.accountId);
    }
}

