/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.Action;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.Status;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.StringUtils;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseAction
implements Action {
    private static final Logger log = new Logger(BaseAction.class);
    private static final List<Platform> ALL_PLATFORMS = Arrays.asList(Platform.values());
    @JsonProperty
    private final Map<String, String> context;
    protected final ManagerToolbox toolbox;

    public BaseAction(ManagerToolbox toolbox, Map<String, String> context) {
        this.context = context != null ? context : new HashMap();
        this.toolbox = toolbox;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    protected ManagerToolbox getToolbox() {
        return this.toolbox;
    }

    @Override
    public final Object perform() {
        if (this.getSupportedPlatforms() == null || !this.getSupportedPlatforms().contains(this.toolbox.getPlatform())) {
            throw new IAE("[%s] is not a supported action for platform [%s]", new Object[]{this.getClass().getSimpleName(), this.toolbox.getPlatform()});
        }
        try {
            ThreadLocalContext.setNoticeOrActionClass(this.getClass());
            ThreadLocalContext.setUserContext(this.context);
            Object object = this.innerPerform();
            return object;
        }
        finally {
            ThreadLocalContext.clear();
        }
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return true;
    }

    protected void handleMagicTags(Account account, Map<String, String> context) {
        Info info;
        if (account == null) {
            return;
        }
        if (account.getAccountId() != null) {
            this.handleMagicTags(account.getAccountId(), context);
        }
        if (account.getName() != null) {
            this.handleMagicTags(account.getName(), context);
        }
        if ((info = this.toolbox.getEntityStateDataManager().getOrNull(account)) != null && info.isMockEntity() != null) {
            ThreadLocalContext.setSystemContext((String)"isMock", (Object)info.isMockEntity());
        }
    }

    protected void handleMagicTags(Cluster cluster, Map<String, String> context) {
        Info info;
        if (cluster == null) {
            return;
        }
        if (cluster.getClusterId() != null) {
            this.handleMagicTags(cluster.getClusterId(), context);
        }
        if (cluster.getName() != null) {
            this.handleMagicTags(cluster.getName(), context);
        }
        if ((info = this.toolbox.getEntityStateDataManager().getOrNull(cluster)) != null && info.isMockEntity() != null) {
            ThreadLocalContext.setSystemContext((String)"isMock", (Object)info.isMockEntity());
        }
    }

    protected void handleMagicTags(String name, Map<String, String> context) {
        if (context == null) {
            return;
        }
        if (name.startsWith("imply_real_")) {
            context.put("isMock", "false");
        } else if (name.startsWith("imply_mock_")) {
            context.put("isMock", "true");
            context.put("name", name);
        }
        if (name.endsWith("_imply_ok")) {
            context.put("mockBehavior", Status.OK.name());
        } else if (name.endsWith("_imply_warning")) {
            context.put("mockBehavior", Status.WARNING.name());
        } else if (name.endsWith("_imply_critical")) {
            context.put("mockBehavior", Status.CRITICAL.name());
        }
    }

    protected Info.Builder getDefaultInfoBuilder(Account account) {
        if (account == null) {
            return Info.builder().withThreadLocalContext();
        }
        return account.getInfoBuilder().withKey(account.key()).withEntityId(account.getAccountId()).withEntityType(EntityType.ACCOUNT).withThreadLocalContext();
    }

    protected Info.Builder getDefaultInfoBuilder(Cluster cluster) {
        if (cluster == null) {
            return Info.builder().withThreadLocalContext();
        }
        return cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext();
    }

    protected Info.Builder getDefaultInfoBuilder() {
        return Info.builder().withThreadLocalContext();
    }

    protected void clearAllNonCriticalNotifications(String entityKey) {
        this.toolbox.getNotificationDataManager().deleteNotificationsWithLevel(entityKey, Notification.Level.INFO);
        this.toolbox.getNotificationDataManager().deleteNotificationsWithLevel(entityKey, Notification.Level.WARNING);
    }

    protected void clearAllNotifications(String entityKey) {
        this.toolbox.getNotificationDataManager().deleteNotificationsWithEntityKey(entityKey);
    }

    protected void markNotificationsAsPrevious(String entityKey) {
        this.toolbox.getNotificationDataManager().markNotificationsAsPrevious(entityKey);
    }

    private void addNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        log.info(Notification.Level.CRITICAL.equals((Object)notification.getLevel()), "[Notification | %s]: %s", new Object[]{notification.getLevel(), notification.getMessage()});
        this.toolbox.getNotificationDataManager().insert(notification);
    }

    protected void addInfoNotification(String entityKey, String message, Object ... formatArgs) {
        this.addInfoNotification(entityKey, Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addInfoNotification(String entityKey, Notification.Source source, String message, Object ... formatArgs) {
        this.addNotification(Notification.of((String)StringUtils.safeFormat((String)message, (Object[])formatArgs), null, (Notification.Level)Notification.Level.INFO, (Notification.Source)source, (String)entityKey));
    }

    protected void addWarningNotification(String entityKey, String message, Object ... formatArgs) {
        this.addWarningNotification(entityKey, Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addWarningNotification(String entityKey, Notification.Source source, String message, Object ... formatArgs) {
        this.addNotification(Notification.of((String)StringUtils.safeFormat((String)message, (Object[])formatArgs), null, (Notification.Level)Notification.Level.WARNING, (Notification.Source)source, (String)entityKey));
    }

    protected void addCriticalNotification(String entityKey, String message, Object ... formatArgs) {
        this.addCriticalNotification(entityKey, Notification.Source.MANAGER, message, formatArgs);
    }

    protected void addCriticalNotification(String entityKey, Notification.Source source, String message, Object ... formatArgs) {
        this.addNotification(Notification.of((String)StringUtils.safeFormat((String)message, (Object[])formatArgs), null, (Notification.Level)Notification.Level.CRITICAL, (Notification.Source)source, (String)entityKey));
    }

    protected String getOnPremAccountIdIfNull(String accountId) {
        return accountId != null || !this.toolbox.isOnPrem() ? accountId : "onprem";
    }

    protected List<Platform> getSupportedPlatforms() {
        return ALL_PLATFORMS;
    }

    protected abstract Object innerPerform();
}

