/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.manager.notice.account.ConfigureVpcPeeringNotice;
import io.imply.cloud.manager.notice.account.CreateAccountNotice;
import io.imply.cloud.manager.notice.account.DeleteAccountRecordNotice;
import io.imply.cloud.manager.notice.account.DeleteNetworkStackNotice;
import io.imply.cloud.manager.notice.account.DeleteVpcPeeringConnectionNotice;
import io.imply.cloud.manager.notice.account.GetAccountUpdateStatusNotice;
import io.imply.cloud.manager.notice.account.GetNetworkStackCreationStatusNotice;
import io.imply.cloud.manager.notice.account.GetNetworkStackDeletionStatusNotice;
import io.imply.cloud.manager.notice.account.SetAccountCreatedNotice;
import io.imply.cloud.manager.notice.account.SetAccountCreationFailedNotice;
import io.imply.cloud.manager.notice.account.SetAccountWithNetworkStackDeletedNotice;
import io.imply.cloud.manager.notice.account.UpdateAccountNotice;
import io.imply.cloud.manager.notice.cluster.CancelClusterAgentsUpdateNotice;
import io.imply.cloud.manager.notice.cluster.CreateClusterStackNotice;
import io.imply.cloud.manager.notice.cluster.CreateRdsSnapshotNotice;
import io.imply.cloud.manager.notice.cluster.CrudClusterMonitoringStackNotice;
import io.imply.cloud.manager.notice.cluster.DeleteClusterMonitoringStackBestEffortNotice;
import io.imply.cloud.manager.notice.cluster.DeleteClusterStackAndSetFailureNotice;
import io.imply.cloud.manager.notice.cluster.DeleteClusterStackNotice;
import io.imply.cloud.manager.notice.cluster.ExecuteStagedOperationNotice;
import io.imply.cloud.manager.notice.cluster.GetClusterMonitoringStackCrudStatusNotice;
import io.imply.cloud.manager.notice.cluster.GetClusterStackCreationStatusNotice;
import io.imply.cloud.manager.notice.cluster.GetClusterStackDeletionStatusNotice;
import io.imply.cloud.manager.notice.cluster.GetClusterStackRollbackStatusNotice;
import io.imply.cloud.manager.notice.cluster.GetRdsSnapshotCreationStatusNotice;
import io.imply.cloud.manager.notice.cluster.HandleRetryUpdateRequestNotice;
import io.imply.cloud.manager.notice.cluster.HandleRollbackUpdateRequestNotice;
import io.imply.cloud.manager.notice.cluster.PlanAgentUpdateNotice;
import io.imply.cloud.manager.notice.cluster.PlanClusterCreationNotice;
import io.imply.cloud.manager.notice.cluster.PlanKubernetesStatefulSetRollingUpdate;
import io.imply.cloud.manager.notice.cluster.PlanRdsUpdateNotice;
import io.imply.cloud.manager.notice.cluster.PlanRollingUpdateNotice;
import io.imply.cloud.manager.notice.cluster.PostCreateNotice;
import io.imply.cloud.manager.notice.cluster.PostDeleteNotice;
import io.imply.cloud.manager.notice.cluster.PostPauseNotice;
import io.imply.cloud.manager.notice.cluster.PostStartNotice;
import io.imply.cloud.manager.notice.cluster.PostStopNotice;
import io.imply.cloud.manager.notice.cluster.PostUpdateNotice;
import io.imply.cloud.manager.notice.cluster.PreCreateNotice;
import io.imply.cloud.manager.notice.cluster.PreDeleteNotice;
import io.imply.cloud.manager.notice.cluster.PreStartNotice;
import io.imply.cloud.manager.notice.cluster.PreStopNotice;
import io.imply.cloud.manager.notice.cluster.PreUpdateNotice;
import io.imply.cloud.manager.notice.cluster.RdsUpdateRollbackNotice;
import io.imply.cloud.manager.notice.cluster.RevertClusterRequestClusterStackRollbackNotice;
import io.imply.cloud.manager.notice.cluster.RevertClusterSetUpdateFailedNotice;
import io.imply.cloud.manager.notice.cluster.RevertClusterSetUpdateRolledBackNotice;
import io.imply.cloud.manager.notice.cluster.RollbackClusterStackNotice;
import io.imply.cloud.manager.notice.cluster.SetClusterCreationFailedNotice;
import io.imply.cloud.manager.notice.cluster.SetClusterRolledBackOrRevertRollingUpdateNotice;
import io.imply.cloud.manager.notice.cluster.SetClusterStartFailedNotice;
import io.imply.cloud.manager.notice.cluster.UpdateClusterStackNotice;
import io.imply.cloud.model.State;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;

public class StateActionTable {
    private static final Logger log = new Logger(StateActionTable.class);

    public static Class<? extends Notice> getAccountNoticeClass(State currentState, State desiredState) {
        if (!StateActionTable.validate(currentState, desiredState)) {
            return null;
        }
        switch (currentState) {
            case ACCOUNT_INFO_RECEIVED: {
                return CreateAccountNotice.class;
            }
            case CREATING_NETWORK_STACK: {
                return GetNetworkStackCreationStatusNotice.class;
            }
            case ACCOUNT_UPDATE_REQUEST_RECEIVED: {
                return UpdateAccountNotice.class;
            }
            case ACCOUNT_UPDATE_IN_PROGRESS: {
                return GetAccountUpdateStatusNotice.class;
            }
            case NETWORK_STACK_CREATED: {
                return ConfigureVpcPeeringNotice.class;
            }
            case ACCOUNT_CONFIGURED: {
                return SetAccountCreatedNotice.class;
            }
            case VPC_PEERING_FAILED: {
                return DeleteVpcPeeringConnectionNotice.class;
            }
            case VPC_PEERING_CONNECTION_DELETED: {
                return DeleteNetworkStackNotice.class;
            }
            case ACCOUNT_DELETE_REQUEST_RECEIVED: {
                return DeleteVpcPeeringConnectionNotice.class;
            }
            case DELETING_NETWORK_STACK: {
                return GetNetworkStackDeletionStatusNotice.class;
            }
            case NETWORK_STACK_DELETED: {
                switch (desiredState) {
                    case ACCOUNT_DELETED: {
                        return DeleteAccountRecordNotice.class;
                    }
                    case ACCOUNT_CREATED: {
                        return SetAccountCreationFailedNotice.class;
                    }
                    case ACCOUNT_WITH_NETWORK_STACK_DELETED: {
                        return SetAccountWithNetworkStackDeletedNotice.class;
                    }
                }
            }
        }
        throw new ISE("Unhandled state [%s] for desired state [%s]", new Object[]{currentState, desiredState});
    }

    public static Class<? extends Notice> getClusterNoticeClass(State currentState, State desiredState) {
        if (!StateActionTable.validate(currentState, desiredState)) {
            return null;
        }
        switch (currentState) {
            case CLUSTER_INFO_RECEIVED: {
                return PreCreateNotice.class;
            }
            case CREATE_CLUSTER_STACK: {
                return CreateClusterStackNotice.class;
            }
            case CLUSTER_STOP_REQUEST_RECEIVED: {
                return PreStopNotice.class;
            }
            case CLUSTER_START_REQUEST_RECEIVED: {
                return PreStartNotice.class;
            }
            case CLUSTER_UPDATE_REQUEST_RECEIVED: 
            case CLUSTER_RESTART_REQUEST_RECEIVED: {
                return PreUpdateNotice.class;
            }
            case CLUSTER_DELETE_REQUEST_RECEIVED: {
                return PreDeleteNotice.class;
            }
            case CLUSTER_DELETE_REQUEST_INTERNAL: {
                return DeleteClusterStackNotice.class;
            }
            case CLUSTER_STACK_DELETED: {
                switch (desiredState) {
                    case CLUSTER_DELETED: {
                        return PostDeleteNotice.class;
                    }
                    case CLUSTER_CREATED: {
                        return SetClusterCreationFailedNotice.class;
                    }
                    case CLUSTER_STOPPED: {
                        return PostStopNotice.class;
                    }
                    case CLUSTER_PAUSED: {
                        return PostPauseNotice.class;
                    }
                    case CLUSTER_STARTED: {
                        return SetClusterStartFailedNotice.class;
                    }
                }
                break;
            }
            case CLUSTER_ROLLING_UPDATE_IN_PROGRESS: {
                return ExecuteStagedOperationNotice.class;
            }
            case PLAN_KUBERNETES_STATEFULSET_ROLLING_UPDATE: {
                return PlanKubernetesStatefulSetRollingUpdate.class;
            }
            case KUBERNETES_STATEFULSET_ROLLING_UPDATE: {
                return ExecuteStagedOperationNotice.class;
            }
            case CLUSTER_ROLLING_UPDATE_COMPLETE: {
                return PostUpdateNotice.class;
            }
            case CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED: {
                return HandleRetryUpdateRequestNotice.class;
            }
            case CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED: 
            case CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED: {
                return HandleRollbackUpdateRequestNotice.class;
            }
            case CLUSTER_UPDATE_REVERT_SPEC_THEN_REQUEST_CF_ROLLBACK: {
                return RevertClusterRequestClusterStackRollbackNotice.class;
            }
            case CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_ROLLED_BACK: {
                return RevertClusterSetUpdateRolledBackNotice.class;
            }
            case CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_FAILED: {
                return RevertClusterSetUpdateFailedNotice.class;
            }
            case PLAN_CLUSTER_CREATION: {
                return PlanClusterCreationNotice.class;
            }
            case CLUSTER_STAGED_CREATION_IN_PROGRESS: {
                return ExecuteStagedOperationNotice.class;
            }
            case CLUSTER_STAGED_CREATION_COMPLETE: {
                switch (desiredState) {
                    case CLUSTER_CREATED: {
                        return PostCreateNotice.class;
                    }
                    case CLUSTER_STARTED: {
                        return PostStartNotice.class;
                    }
                }
                break;
            }
            case CLUSTER_STAGED_CREATION_FAILED: {
                switch (desiredState) {
                    case CLUSTER_CREATED: {
                        return SetClusterCreationFailedNotice.class;
                    }
                    case CLUSTER_STARTED: {
                        return SetClusterStartFailedNotice.class;
                    }
                }
                break;
            }
            case PLAN_CLUSTER_AGENT_UPDATE: {
                return PlanAgentUpdateNotice.class;
            }
            case CLUSTER_AGENT_UPDATE_IN_PROGRESS: {
                return ExecuteStagedOperationNotice.class;
            }
            case CLUSTER_AGENT_CANCEL_UPDATE: {
                return CancelClusterAgentsUpdateNotice.class;
            }
            case PLAN_CLUSTER_UPDATE: {
                return PlanRollingUpdateNotice.class;
            }
            case CREATING_CLUSTER_STACK: {
                return GetClusterStackCreationStatusNotice.class;
            }
            case CRUD_CLUSTER_MONITORING_STACK: {
                return CrudClusterMonitoringStackNotice.class;
            }
            case CRUDING_CLUSTER_MONITORING_STACK: {
                return GetClusterMonitoringStackCrudStatusNotice.class;
            }
            case CLUSTER_STACK_CREATED: {
                switch (desiredState) {
                    case CLUSTER_CREATED: {
                        return PostCreateNotice.class;
                    }
                    case CLUSTER_STARTED: {
                        return PostStartNotice.class;
                    }
                }
                break;
            }
            case UPDATING_CLUSTER_STACK: {
                return GetClusterStackCreationStatusNotice.class;
            }
            case CLUSTER_UPDATE_REQUEST_INTERNAL: {
                return UpdateClusterStackNotice.class;
            }
            case CLUSTER_UPDATE_ROLLBACK_STACK: {
                return RollbackClusterStackNotice.class;
            }
            case CLUSTER_UPDATE_ROLLING_BACK_STACK: {
                return GetClusterStackRollbackStatusNotice.class;
            }
            case CLUSTER_UPDATE_ROLLED_BACK_STACK: {
                return SetClusterRolledBackOrRevertRollingUpdateNotice.class;
            }
            case CLUSTER_STACK_UPDATED: {
                return PlanRollingUpdateNotice.class;
            }
            case CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED: {
                return CreateRdsSnapshotNotice.class;
            }
            case CREATING_RDS_SNAPSHOT: {
                return GetRdsSnapshotCreationStatusNotice.class;
            }
            case RDS_SNAPSHOT_CREATED: {
                switch (desiredState) {
                    case CLUSTER_DELETED: 
                    case CLUSTER_STOPPED: 
                    case CLUSTER_PAUSED: {
                        return DeleteClusterStackNotice.class;
                    }
                    case CLUSTER_UPDATED: {
                        return UpdateClusterStackNotice.class;
                    }
                }
                break;
            }
            case PLAN_RDS_UPDATE: {
                return PlanRdsUpdateNotice.class;
            }
            case RDS_UPDATE_IN_PROGRESS: {
                return ExecuteStagedOperationNotice.class;
            }
            case RDS_UPDATE_ROLLBACK: {
                return RdsUpdateRollbackNotice.class;
            }
            case CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION: {
                return DeleteClusterStackAndSetFailureNotice.class;
            }
            case CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION: {
                return DeleteClusterMonitoringStackBestEffortNotice.class;
            }
            case DELETING_CLUSTER_STACK: {
                return GetClusterStackDeletionStatusNotice.class;
            }
        }
        throw new ISE("Unhandled state [%s] for desired state [%s]", new Object[]{currentState, desiredState});
    }

    private static boolean validate(State currentState, State desiredState) {
        if (desiredState == null || !desiredState.isFinalState()) {
            throw new ISE("Desired state [%s] must be a final state", new Object[]{desiredState});
        }
        if (currentState == null || currentState.isFinalState()) {
            log.info("State [%s] is a final state and has no further actions", new Object[]{currentState});
            return false;
        }
        return true;
    }
}

