/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.imply.cloud.exception.AccessDeniedException;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.Action;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.manager.action.BaseAction;
import io.imply.cloud.manager.util.ManagerLeaderProxy;
import io.imply.cloud.model.AuditEntry;
import io.imply.cloud.model.DefaultsAndSupportedValues;
import io.imply.cloud.model.DefaultsAndSupportedValuesForVersion;
import io.imply.cloud.model.ImpersonatedUser;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.AuditDataManager;
import io.imply.cloud.persistence.UserDataManager;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ThreadUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.NoResultsException;

@Path(value="/manager/v1")
public class ManagerResource {
    private static final Logger log = new Logger(ManagerResource.class);
    private final ManagerToolbox toolbox;
    private final ManagerConfig config;
    private final UserDataManager userDataManager;
    private final AuditDataManager auditDataManager;
    private final ManagerLeader managerLeader;
    private final ObjectMapper objectMapper;
    private final ManagerLeaderProxy managerLeaderProxy;

    @Inject
    public ManagerResource(ManagerToolbox toolbox, AuditDataManager auditDataManager, ManagerLeader managerLeader, ManagerLeaderProxy managerLeaderProxy) {
        this.toolbox = toolbox;
        this.config = toolbox.getManagerConfig();
        this.userDataManager = toolbox.getUserDataManager();
        this.objectMapper = toolbox.getObjectMapper();
        this.auditDataManager = auditDataManager;
        this.managerLeader = managerLeader;
        this.managerLeaderProxy = managerLeaderProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="action")
    @Produces(value={"application/json"})
    public Response actionPost(@HeaderParam(value="X-Request-ID") String requestIdUser, @Context HttpServletResponse response, @Context HttpServletRequest request, byte[] data) throws Exception {
        User principal;
        BaseAction baseAction;
        Action action = (Action)this.objectMapper.readValue(data, Action.class);
        if (!this.isLeading() && action.isHandleableByLeaderOnly()) {
            return this.managerLeaderProxy.proxyRequest(request, data);
        }
        String requestId = (String)StringUtils.defaultIfEmpty((CharSequence)requestIdUser, (CharSequence)UUID.randomUUID().toString().substring(0, 23));
        String spanId = UUID.randomUUID().toString().substring(0, 8);
        String parentSpanId = request.getHeader("X-B3-ParentSpanId");
        if (action instanceof BaseAction && (baseAction = (BaseAction)action).getContext() != null && baseAction.getContext().get("requestId") != null && !baseAction.getContext().get("requestId").isEmpty()) {
            requestId = baseAction.getContext().get("requestId");
        }
        if (action instanceof AuthenticatedAction) {
            AuthenticatedAction authenticatedAction = (AuthenticatedAction)action;
            if (this.isSuperPrincipal(authenticatedAction.getPrincipalId())) {
                principal = new User("SUPER_PRINCIPAL", "SUPER_PRINCIPAL", null, null, null, null);
            } else {
                principal = this.getUser(request, authenticatedAction);
                if (!authenticatedAction.isAuthorized(principal)) {
                    throw new AccessDeniedException(String.format("Authorization failed: principal [%s] is not allowed to perform this action", principal.getUserId()), new Object[0]);
                }
                principal = this.maybeUpdateWithImpersonator(request, authenticatedAction, principal);
            }
        } else {
            principal = new User("ANONYMOUS", "ANONYMOUS", null, null, null, null);
        }
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(ThreadUtils.getExtendedThreadName((String)originalThreadName, (String)principal.getDetailedUserId(), (String)requestId));
        if (action.logRequestAsDebugLevel()) {
            log.debug("#%s %s", new Object[]{principal.getDetailedUserId(), action});
        } else {
            log.info("#%s %s", new Object[]{principal.getDetailedUserId(), action});
        }
        try {
            ThreadLocalContext.setCacheId((String)UUID.randomUUID().toString().substring(0, 8));
            ThreadLocalContext.setRequestId((String)requestId);
            ThreadLocalContext.setParentSpanId((String)parentSpanId);
            ThreadLocalContext.setSpanId((String)spanId);
            ThreadLocalContext.setPrincipal((User)principal);
            response.setHeader("X-Request-ID", requestId);
            response.setHeader("X-User-ID", principal.getDetailedUserId());
            if (!Action.getNonAuditedActions().contains(action.getClass())) {
                if (action.getAccountIds() == null || action.getAccountIds().isEmpty()) {
                    this.auditDataManager.insert(new AuditEntry(principal.getDetailedUserId(), null, requestId, action.getClass().getSimpleName(), action.toString(), DateTime.now()));
                } else {
                    for (String accountId : action.getAccountIds()) {
                        this.auditDataManager.insert(new AuditEntry(principal.getDetailedUserId(), accountId, requestId, action.getClass().getSimpleName(), action.toString(), DateTime.now()));
                    }
                }
            }
            Response response2 = Response.ok((Object)action.perform()).build();
            return response2;
        }
        finally {
            ThreadLocalContext.clear();
            Thread.currentThread().setName(originalThreadName);
        }
    }

    @GET
    @Path(value="info")
    @Produces(value={"application/json"})
    public DefaultsAndSupportedValues getInfo(@QueryParam(value="accountId") String accountId) {
        return this.toolbox.getInfoRouteManager().getDefaultsAndSupportedValues(accountId);
    }

    @GET
    @Path(value="info/{version}")
    @Produces(value={"application/json"})
    public DefaultsAndSupportedValuesForVersion getInfoForVersion(@PathParam(value="version") String version, @QueryParam(value="accountId") String accountId) {
        return this.toolbox.getInfoRouteManager().getDefaultsAndSupportedValuesForVersion(accountId, version);
    }

    @GET
    @Path(value="audit/{requestId}")
    @Produces(value={"application/json"})
    public AuditEntry getAuditEntry(@PathParam(value="requestId") String requestId) {
        return this.auditDataManager.get(requestId);
    }

    @GET
    @Path(value="billing-report")
    @Produces(value={"application/octet-stream"})
    public Response getBillingReport(final @QueryParam(value="start") String start, final @QueryParam(value="end") String end) {
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                ManagerResource.this.toolbox.getBillingReportManager().generateReport(output, start, end);
            }
        };
        return Response.ok((Object)output).header("Content-Disposition", (Object)String.format("attachment;filename=report-%s.csv", DateTime.now().toString("yyyy-MM-dd"))).build();
    }

    private boolean isSuperPrincipal(String principal) {
        return this.config.getSuperPrincipal() != null && this.config.getSuperPrincipal().equals(principal);
    }

    private boolean isLeading() {
        return this.managerLeader.isLeader();
    }

    private User getUser(HttpServletRequest request, AuthenticatedAction action) {
        if (request.getUserPrincipal() instanceof User) {
            return (User)request.getUserPrincipal();
        }
        return this.getBuiltinUser(action);
    }

    private User getBuiltinUser(AuthenticatedAction authenticatedAction) {
        User principal;
        try {
            principal = this.userDataManager.get(authenticatedAction.getPrincipalId());
        }
        catch (DBIException e) {
            if (e instanceof NoResultsException || e.getCause() != null && e.getCause() instanceof NoResultsException) {
                throw new AccessDeniedException(String.format("Authorization failed: principal [%s] was not found", authenticatedAction.getPrincipalId()), new Object[0]);
            }
            throw e;
        }
        return principal;
    }

    private User maybeUpdateWithImpersonator(HttpServletRequest request, AuthenticatedAction action, User user) {
        if (request.getUserPrincipal() instanceof ImpersonatedUser) {
            return (ImpersonatedUser)request.getUserPrincipal();
        }
        return this.maybeGetBuiltinImpersonator(action, user);
    }

    private User maybeGetBuiltinImpersonator(AuthenticatedAction authenticatedAction, User user) {
        if (authenticatedAction.getContext() != null && authenticatedAction.getContext().get("impersonator") != null) {
            return new ImpersonatedUser(user, authenticatedAction.getContext().get("impersonator"));
        }
        return user;
    }
}

