/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.CreationAgentConfig;
import io.imply.cloud.config.OtelCollectorConfig;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.DefaultsAndSupportedValues;
import io.imply.cloud.model.DefaultsAndSupportedValuesForVersion;
import io.imply.cloud.model.DruidExtensions;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.OtelCollector;
import io.imply.cloud.model.Pivot;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ImplyVersionHelper;
import io.imply.cloud.util.InstanceTypeHelper;

public abstract class InfoRouteManager {
    protected final ClusterDataManager clusterDataManager;
    protected final CreationAgentConfig creationAgentConfig;
    protected final ApplicationConfig applicationConfig;
    protected final ImplyVersionHelper implyVersionHelper;
    protected final AccountDataManager accountDataManager;
    protected final RefreshableConstants refreshableConstants;
    protected final InstanceTypeHelper instanceTypeHelper;
    protected final OtelCollectorConfig otelCollectorConfig;

    @Inject
    public InfoRouteManager(ClusterDataManager clusterDataManager, CreationAgentConfig creationAgentConfig, ApplicationConfig applicationConfig, ImplyVersionHelper implyVersionHelper, AccountDataManager accountDataManager, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper, OtelCollectorConfig otelCollectorConfig) {
        this.clusterDataManager = clusterDataManager;
        this.creationAgentConfig = creationAgentConfig;
        this.applicationConfig = applicationConfig;
        this.implyVersionHelper = implyVersionHelper;
        this.accountDataManager = accountDataManager;
        this.refreshableConstants = refreshableConstants;
        this.instanceTypeHelper = instanceTypeHelper;
        this.otelCollectorConfig = otelCollectorConfig;
    }

    public abstract DefaultsAndSupportedValues getDefaultsAndSupportedValues(String var1);

    public DefaultsAndSupportedValuesForVersion getDefaultsAndSupportedValuesForVersion(String accountId, String version) {
        Account account = accountId != null ? this.accountDataManager.get(accountId) : Account.builder().build();
        ImplyVersion implyVersion = new ImplyVersion(version, this.refreshableConstants);
        DefaultsAndSupportedValuesForVersion defaults = new DefaultsAndSupportedValuesForVersion(DruidExtensions.getForImplyVersion((ImplyVersion)implyVersion, (RefreshableConstants)this.refreshableConstants), FeatureFlag.getForImplyVersionAndPlatform((ImplyVersion)implyVersion, (ApplicationConfig)this.applicationConfig, (Account)account, (RefreshableConstants)this.refreshableConstants), DeepStorage.getForImplyVersion((ImplyVersion)implyVersion, (ApplicationConfig)this.applicationConfig, (RefreshableConstants)this.refreshableConstants).keySet(), Pivot.getForImplyVersion((ImplyVersion)implyVersion, (ApplicationConfig)this.applicationConfig).keySet(), OtelCollector.getDefaultConfig((OtelCollectorConfig)this.otelCollectorConfig));
        return defaults;
    }
}

