/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.Pivot;
import io.imply.cloud.model.PlanUpdateState;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.model.User;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.DiffResultHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;

public class ClusterUpdateHelper {
    private static final Logger log = new Logger(ClusterUpdateHelper.class);
    private final ClusterDataManager clusterDataManager;
    private final EntityStateDataManager entityStateDataManager;
    private final ApplicationConfig applicationConfig;
    private final ObjectMapper objectMapper;
    protected final RefreshableConstants refreshableConstants;

    public static Set<UpdateDetails> buildUnsupportedUpdate(String displayText) {
        return ImmutableSet.of((Object)new UpdateDetails(UpdateType.UNSUPPORTED, null, displayText));
    }

    public static Set<UpdateDetails> buildNoChangeUpdate() {
        return ImmutableSet.of((Object)new UpdateDetails(UpdateType.NO_CHANGE, null));
    }

    public List<UpdateDetails> getUpdateDetailsForClusterDiff(Cluster diff, Cluster previousCluster) {
        log.info("Generating update details for cluster diff [%s] previousCluster [%s]", new Object[]{diff, previousCluster});
        ArrayList<Set<UpdateDetails>> updateDetailsList = new ArrayList<Set<UpdateDetails>>();
        if (diff == null || diff.cloner().withVersion(null).withCreated(null).withLastModified(null).withCreatedBy(null).withModifiedBy(null).withComments(null).build().isEmpty()) {
            updateDetailsList.add(ClusterUpdateHelper.buildNoChangeUpdate());
        } else {
            this.getSupportedUpdatesForClusterDiff(diff, previousCluster, updateDetailsList);
        }
        if (updateDetailsList.isEmpty()) {
            log.warn("Unhandled cluster configuration changes [%s]", new Object[]{diff});
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
        return this.getUpdateOptions(updateDetailsList, diff, previousCluster, true);
    }

    public List<UpdateDetails> getUpdateDetailsForClusterDiff(DiffResult<Cluster> diffs) {
        log.info("Generating update details for cluster diffs: %s", new Object[]{diffs});
        ArrayList<Set<UpdateDetails>> updateDetailsList = new ArrayList<Set<UpdateDetails>>();
        if (diffs == null || DiffResultHelper.isEmpty(diffs, (String[])new String[]{"version", "comments"})) {
            updateDetailsList.add(ClusterUpdateHelper.buildNoChangeUpdate());
            return this.getUpdateOptions(updateDetailsList, null, null, true);
        }
        this.getSupportedUpdatesForClusterDiff(diffs, updateDetailsList);
        if (updateDetailsList.isEmpty()) {
            log.warn("Unhandled cluster configuration changes: %s", new Object[]{diffs});
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
        return this.getUpdateOptions(updateDetailsList, (Cluster)diffs.getRight(), (Cluster)diffs.getLeft(), true);
    }

    public List<UpdateDetails> getUpdateDetailsForClusterNodesDiff(ClusterNodes diff, ClusterNodes previousClusterNodes) {
        log.info("Generating update details for clusterNodes diff [%s] previousClusterNodes [%s]", new Object[]{diff, previousClusterNodes});
        ArrayList<Set<UpdateDetails>> updateDetailsList = new ArrayList<Set<UpdateDetails>>();
        if (diff == null || diff.cloner().withVersion(null).withLastModified(null).withModifiedBy(null).build().isEmpty()) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)new UpdateDetails(UpdateType.NO_CHANGE, null)));
        } else {
            Cluster cluster = this.clusterDataManager.get(previousClusterNodes.getClusterId());
            this.getSupportedUpdatesForClusterNodesDiff(diff, previousClusterNodes, cluster, updateDetailsList);
        }
        return this.getUpdateOptions(updateDetailsList, null, null, true);
    }

    public int getTotalMICU(String accountId, Cluster proposedCluster) {
        ArrayList existingClustersWithoutProposed = new ArrayList(this.clusterDataManager.getAllWithAccountId(accountId).stream().filter(x -> proposedCluster == null || proposedCluster.getClusterId() == null || !proposedCluster.getClusterId().equals(x.getClusterId())).collect(Collectors.toList()));
        ArrayList<Cluster> includedClusters = new ArrayList<Cluster>();
        for (Cluster cluster : existingClustersWithoutProposed) {
            Info info = this.entityStateDataManager.getOrNull(cluster);
            if (info == null || info.getState() == null || !info.getState().isRunning() && !info.getState().isTransitionState()) continue;
            includedClusters.add(cluster);
        }
        if (proposedCluster != null) {
            includedClusters.add(proposedCluster);
        }
        int totalMICU = 0;
        for (Cluster cluster : includedClusters) {
            InstanceType masterInstanceType = this.refreshableConstants.getSupportedMasterInstanceTypes().stream().filter(x -> x.getInstanceType().equals(cluster.getMasterInstanceType())).findFirst().orElse(null);
            InstanceType queryInstanceType = this.refreshableConstants.getSupportedQueryInstanceTypes().stream().filter(x -> x.getInstanceType().equals(cluster.getQueryInstanceType())).findFirst().orElse(null);
            if (masterInstanceType == null || masterInstanceType.getMICU() == null) {
                throw new ISE("Could not retrieve MICU data for master [%s]", new Object[]{cluster.getMasterInstanceType()});
            }
            if (queryInstanceType == null || queryInstanceType.getMICU() == null) {
                throw new ISE("Could not retrieve MICU data for query [%s]", new Object[]{cluster.getQueryInstanceType()});
            }
            totalMICU += cluster.getMasterInstanceCount() * masterInstanceType.getMICU() + cluster.getQueryInstanceCount() * queryInstanceType.getMICU();
            for (InstanceTier tier : cluster.getDataInstanceTiers().values()) {
                InstanceType dataInstanceType = this.refreshableConstants.getSupportedDataInstanceTypes().stream().filter(x -> x.getInstanceType().equals(tier.getInstanceType())).findFirst().orElse(null);
                if (dataInstanceType == null || dataInstanceType.getMICU() == null) {
                    throw new ISE("Could not retrieve MICU data for data [%s]", new Object[]{tier.getInstanceType()});
                }
                totalMICU += tier.getInstanceCount() * dataInstanceType.getMICU();
            }
        }
        return totalMICU;
    }

    public String generateModifiedCoordinatorDynamicConfiguration(String originalCoordinatorDynamicConfiguration, int maxSegmentsToMove, int replicationThrottleLimit) {
        if (originalCoordinatorDynamicConfiguration == null) {
            return null;
        }
        try {
            Object myReplicationThrottleLimit;
            Map configAsMap = (Map)this.objectMapper.readValue(originalCoordinatorDynamicConfiguration, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Object myMaxSegmentsToMove = configAsMap.get("maxSegmentsToMove");
            if (myMaxSegmentsToMove == null || myMaxSegmentsToMove instanceof Number && ((Number)myMaxSegmentsToMove).longValue() < (long)maxSegmentsToMove) {
                configAsMap.put("maxSegmentsToMove", maxSegmentsToMove);
            }
            if ((myReplicationThrottleLimit = configAsMap.get("replicationThrottleLimit")) == null || myReplicationThrottleLimit instanceof Number && ((Number)myReplicationThrottleLimit).longValue() < (long)replicationThrottleLimit) {
                configAsMap.put("replicationThrottleLimit", replicationThrottleLimit);
            }
            configAsMap.put("maxSegmentsInNodeLoadingQueue", 500);
            return this.objectMapper.writeValueAsString((Object)configAsMap);
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Failed to deserialize coordinator dynamic configuration; continuing without adjusting maxSegmentsToMove, replicationThrottleLimit, or maxSegmentsInNodeLoadingQueue");
            return null;
        }
    }

    public String generateModifiedCoordinatorDynamicConfigurationForSurgeUpdates(String originalCoordinatorDynamicConfiguration, Set<String> decommissioningNodes) {
        if (originalCoordinatorDynamicConfiguration == null) {
            throw new ISE("Failed to load coordinatorDynamicConfiguration to set decommissioningNodes in a surge update, check the coordinator dynamic config or use a regular rolling update", new Object[0]);
        }
        try {
            Map configAsMap = (Map)this.objectMapper.readValue(originalCoordinatorDynamicConfiguration, (TypeReference)new TypeReference<Map<String, Object>>(){});
            configAsMap.put("decommissioningNodes", new ArrayList<String>(decommissioningNodes));
            return this.objectMapper.writeValueAsString((Object)configAsMap);
        }
        catch (IOException e) {
            throw new ISE("Failed to set decommissioningNodes in a surge update, check the coordinator dynamic config or use a regular rolling update", new Object[0]);
        }
    }

    public String generateModifiedCoordinatorDynamicConfigurationForCanaryUpdates(Map<String, String> clones) {
        try {
            HashMap<String, Object> configAsMap = new HashMap<String, Object>();
            configAsMap.put("cloneServers", clones);
            configAsMap.put("turboLoadingNodes", clones.keySet());
            return this.objectMapper.writeValueAsString(configAsMap);
        }
        catch (IOException e) {
            throw new ISE("Failed to set cloneServers in a canary update, check the coordinator dynamic config or use a regular rolling update", new Object[0]);
        }
    }

    public boolean canSupportRollingUpdates(Cluster cluster) {
        return cluster != null && cluster.getMasterInstanceCount() != null && cluster.getMasterInstanceCount() > 1;
    }

    protected void addHardOnlyIfFalseElseBoth(boolean value, List<Set<UpdateDetails>> updateDetailsList, int hardEstimatedTimeInMinutes, int rollingEstimatedTimeInMinutes) {
        if (value) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)hardEstimatedTimeInMinutes), (Object)UpdateDetails.rolling((int)rollingEstimatedTimeInMinutes)));
        } else {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)hardEstimatedTimeInMinutes, (String)"This change is only supported as a rolling update for highly available clusters (multiple master nodes).")));
        }
    }

    protected void getSupportedUpdatesForClusterDiff(Cluster diff, Cluster previousCluster, List<Set<UpdateDetails>> updateDetailsList) {
        boolean canSupportRollingUpdates = this.canSupportRollingUpdates(previousCluster);
        if (diff.getAccountId() != null) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Account ID cannot be updated."));
        }
        if (diff.getClusterId() != null) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Cluster ID cannot be updated."));
        }
        if (diff.getClusterNumber() != null) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Cluster number cannot be updated."));
        }
        if (diff.getConfigServerKey() != null) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Config server key cannot be updated."));
        }
        if (diff.getName() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (diff.getImplyVersionFull() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getMasterInstanceType() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getQueryInstanceType() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999)));
        }
        if (diff.getQueryInstanceCount() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)15)));
        }
        if (diff.getDataInstanceTiers() != null) {
            updateDetailsList.add((Set<UpdateDetails>)(this.isOnlyInstanceIncrease(diff, previousCluster) ? ImmutableSet.of((Object)UpdateDetails.rolling((int)999)) : ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999))));
        }
        if (diff.getLogRetentionDays() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (diff.isDeletionProtection() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (diff.isStopProtection() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (diff.getCustomDruidProperties() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getUserExtensions() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getExtensionLoadList() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getCustomFiles() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getDeepStorage() != null && !diff.getDeepStorage().isEmpty()) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.isEncryptDataVolumes() != null) {
            this.getSupportedUpdatesForEncryptDataVolumes(previousCluster, updateDetailsList);
        }
        if (diff.getFeatureFlags() != null) {
            this.getSupportedUpdatesForFeatureFlags(previousCluster.getFeatureFlags(), diff.getFeatureFlags(), updateDetailsList, canSupportRollingUpdates);
        }
        if (diff.getSecurityConfiguration() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.getMetadataStorage() != null) {
            updateDetailsList.addAll(diff.getMetadataStorage().getSupportedUpdatesForDiff(previousCluster, canSupportRollingUpdates));
        }
        if (diff.getDeepStorage() != null) {
            updateDetailsList.addAll(diff.getDeepStorage().getSupportedUpdatesForDiff(canSupportRollingUpdates));
        }
        if (diff.getZooKeeper() != null) {
            updateDetailsList.addAll(diff.getZooKeeper().getSupportedUpdatesForDiff(previousCluster));
        }
        if (diff.getMetadata() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (diff.getUserTags() != null) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (diff.isUseTls() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
        if (diff.isUseAuthentication() != null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
        if (diff.getPivot() != null) {
            updateDetailsList.addAll(diff.getPivot().getSupportedUpdatesForDiff(canSupportRollingUpdates));
        }
    }

    protected void getSupportedUpdatesForClusterDiff(DiffResult<Cluster> diffs, List<Set<UpdateDetails>> updateDetailsList) {
        Diff pivotDiff;
        Diff zooKeeperDiff;
        Diff deepStorageDiff;
        Diff metadataStorageDiff;
        boolean canSupportRollingUpdates = this.canSupportRollingUpdates((Cluster)diffs.getLeft());
        if (DiffResultHelper.contains(diffs, (String)"accountId")) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Account ID cannot be updated."));
        }
        if (DiffResultHelper.contains(diffs, (String)"clusterId")) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Cluster ID cannot be updated."));
        }
        if (DiffResultHelper.contains(diffs, (String)"clusterNumber")) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Cluster number cannot be updated."));
        }
        if (DiffResultHelper.contains(diffs, (String)"configServerKey")) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Config server key cannot be updated."));
        }
        if (DiffResultHelper.contains(diffs, (String)"name")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (DiffResultHelper.contains(diffs, (String)"implyVersionFull")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"masterInstanceType")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"queryInstanceType")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999)));
        }
        if (DiffResultHelper.contains(diffs, (String)"queryInstanceCount")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)15)));
        }
        if (DiffResultHelper.contains(diffs, (String)"dataInstanceTiers")) {
            updateDetailsList.add((Set<UpdateDetails>)(this.isOnlyInstanceIncrease((Cluster)diffs.getRight(), (Cluster)diffs.getLeft()) ? ImmutableSet.of((Object)UpdateDetails.rolling((int)999)) : ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999))));
        }
        if (DiffResultHelper.contains(diffs, (String)"logRetentionDays")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (DiffResultHelper.contains(diffs, (String)"deletionProtection")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (DiffResultHelper.contains(diffs, (String)"stopProtection")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (DiffResultHelper.contains(diffs, (String)"customDruidProperties")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"userExtensions")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"extensionLoadList")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"customFiles")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"deepStorage")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"encryptDataVolumes")) {
            this.getSupportedUpdatesForEncryptDataVolumes((Cluster)diffs.getLeft(), updateDetailsList);
        }
        Diff featureFlagsDiff = DiffResultHelper.get(diffs, (String)"featureFlags");
        if (DiffResultHelper.contains(diffs, (String)"featureFlags")) {
            this.getSupportedUpdatesForFeatureFlags((List)featureFlagsDiff.getLeft(), (List)featureFlagsDiff.getRight(), updateDetailsList, canSupportRollingUpdates);
        }
        if (DiffResultHelper.contains(diffs, (String)"securityConfiguration")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if ((metadataStorageDiff = DiffResultHelper.get(diffs, (String)"metadataStorage")) != null) {
            updateDetailsList.addAll(((MetadataStorage)metadataStorageDiff.getRight()).getSupportedUpdatesForDiff(metadataStorageDiff, canSupportRollingUpdates));
        }
        if ((deepStorageDiff = DiffResultHelper.get(diffs, (String)"deepStorage")) != null) {
            updateDetailsList.addAll(((DeepStorage)deepStorageDiff.getRight()).getSupportedUpdatesForDiff(deepStorageDiff, canSupportRollingUpdates));
        }
        if ((zooKeeperDiff = DiffResultHelper.get(diffs, (String)"zookeeper")) != null) {
            updateDetailsList.addAll(((ZooKeeper)zooKeeperDiff.getRight()).getSupportedUpdatesForDiff(zooKeeperDiff));
        }
        if (DiffResultHelper.contains(diffs, (String)"metadata")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)0)));
        }
        if (DiffResultHelper.contains(diffs, (String)"userTags")) {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
        if (DiffResultHelper.contains(diffs, (String)"useTls")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
        if (DiffResultHelper.contains(diffs, (String)"useAuthentication")) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
        if ((pivotDiff = DiffResultHelper.get(diffs, (String)"pivot")) != null) {
            updateDetailsList.addAll(((Pivot)pivotDiff.getRight()).getSupportedUpdatesForDiff(pivotDiff, canSupportRollingUpdates));
        }
    }

    private void getSupportedUpdatesForEncryptDataVolumes(Cluster prev, List<Set<UpdateDetails>> updateDetailsList) {
        Info info = this.entityStateDataManager.get(prev);
        if (!State.STOPPED.equals((Object)info.getState().getExternalState(info.getDesiredState()))) {
            updateDetailsList.add(ClusterUpdateHelper.buildUnsupportedUpdate("Data volume encryption cannot be modified unless the cluster is stopped"));
        }
        updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999)));
    }

    private void getSupportedUpdatesForFeatureFlags(List<String> prev, List<String> next, List<Set<UpdateDetails>> updateDetailsList, boolean canSupportRollingUpdates) {
        boolean hardUpdateRequiredPrev;
        boolean hardUpdateRequiredDiff = FeatureFlag.getForIds(next, (RefreshableConstants)this.refreshableConstants).stream().anyMatch(featureFlag -> UpdateType.HARD.equals((Object)featureFlag.getRequiredUpdateType()));
        if (hardUpdateRequiredDiff ^ (hardUpdateRequiredPrev = FeatureFlag.getForIds(prev, (RefreshableConstants)this.refreshableConstants).stream().anyMatch(featureFlag -> UpdateType.HARD.equals((Object)featureFlag.getRequiredUpdateType())))) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        } else {
            this.addHardOnlyIfFalseElseBoth(canSupportRollingUpdates, updateDetailsList, 30, 999);
        }
    }

    protected void getSupportedUpdatesForClusterNodesDiff(ClusterNodes diff, ClusterNodes previousClusterNodes, Cluster cluster, List<Set<UpdateDetails>> updateDetailsList) {
        throw new UnsupportedOperationException();
    }

    protected List<UpdateDetails> getUpdateOptions(List<Set<UpdateDetails>> updateDetailsList, @Nullable Cluster diff, @Nullable Cluster previousCluster, boolean clusterHasNodes) {
        boolean canDoRolling = false;
        boolean canDoHard = true;
        ArrayList<String> hardDisplayText = new ArrayList<String>();
        ArrayList<String> rollingDisplayText = new ArrayList<String>();
        int longestRollingTime = 0;
        int longestHardTime = 0;
        if (!clusterHasNodes) {
            hardDisplayText.add("These changes will be immediately applied to the cluster definition.");
        } else {
            canDoRolling = true;
            for (Set<UpdateDetails> updateDetailsSet : updateDetailsList) {
                boolean setContainsRolling = false;
                for (UpdateDetails updateDetails : updateDetailsSet) {
                    if (UpdateType.ROLLING.equals((Object)updateDetails.getType())) {
                        setContainsRolling = true;
                        longestRollingTime = Math.max(longestRollingTime, updateDetails.getEstimatedTimeInMinutes());
                        if (updateDetails.getDisplayText() == null) continue;
                        rollingDisplayText.addAll(updateDetails.getDisplayText());
                        continue;
                    }
                    if (UpdateType.HARD.equals((Object)updateDetails.getType())) {
                        longestHardTime = Math.max(longestHardTime, updateDetails.getEstimatedTimeInMinutes());
                        if (updateDetails.getDisplayText() == null) continue;
                        hardDisplayText.addAll(updateDetails.getDisplayText());
                        continue;
                    }
                    if (ImmutableSet.of((Object)UpdateType.UNSUPPORTED, (Object)UpdateType.NO_CHANGE).contains((Object)updateDetails.getType())) {
                        return ImmutableList.of((Object)updateDetails);
                    }
                    throw new ISE("Unhandled UpdateType [%s]", new Object[]{updateDetails.getType()});
                }
                canDoRolling &= setContainsRolling;
            }
            boolean bl = canDoHard = longestHardTime != 0;
            if (this.applicationConfig.isGroveBased()) {
                longestHardTime = Integer.MAX_VALUE;
            }
            boolean displayedUpdateText2_9_17To3_0_0 = false;
            if (canDoRolling && diff != null && previousCluster != null && diff.getImplyVersionFull() != null && previousCluster.getImplyVersionFull() != null) {
                ComparableVersion previousImplyVersion = previousCluster.lookupComparableImplyVersion(this.refreshableConstants);
                ComparableVersion nextImplyVersion = diff.lookupComparableImplyVersion(this.refreshableConstants);
                ComparableVersion twoNineSeventeenVersion = new ComparableVersion("2.9.17");
                ComparableVersion threeOhOhVersion = new ComparableVersion("3.0.0");
                if (previousImplyVersion != null && nextImplyVersion != null && (previousImplyVersion.compareTo(twoNineSeventeenVersion) <= 0 && nextImplyVersion.compareTo(threeOhOhVersion) >= 0 || previousImplyVersion.compareTo(threeOhOhVersion) >= 0 && nextImplyVersion.compareTo(twoNineSeventeenVersion) <= 0)) {
                    rollingDisplayText.add("NOTE: Although this update can be performed without any disruption to Druid, due to changes in Pivot's update mechanism, Pivot may become unavailable while upgrading from a version earlier than 2.9.18 to 3.0.0+. To perform a rolling update without interruption to Pivot, please upgrade to 2.9.18 first.");
                    displayedUpdateText2_9_17To3_0_0 = true;
                }
            }
            if (canDoRolling) {
                if (!displayedUpdateText2_9_17To3_0_0) {
                    rollingDisplayText.add("These changes can be applied without any service interruption.");
                }
                if (canDoHard) {
                    hardDisplayText.add("Alternatively these changes can be applied faster if you choose an abrupt restart. This will interrupt the service for a few minutes.");
                }
            } else if (canDoHard) {
                hardDisplayText.add("In order to apply these changes you will need to restart the cluster. This will interrupt the service for a few minutes.");
            }
        }
        ImmutableList.Builder updateOptions = ImmutableList.builder();
        if (canDoRolling) {
            updateOptions.add((Object)new UpdateDetails(UpdateType.ROLLING, Integer.valueOf(longestRollingTime), rollingDisplayText.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList())));
        }
        if (canDoHard) {
            updateOptions.add((Object)new UpdateDetails(UpdateType.HARD, Integer.valueOf(longestHardTime), hardDisplayText.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList())));
        }
        return updateOptions.build();
    }

    protected boolean isOnlyInstanceIncrease(Cluster diff, Cluster previousCluster) {
        if (diff == null || previousCluster == null || diff.getDataInstanceTiers() == null || previousCluster.getDataInstanceTiers() == null || diff.getDataInstanceTiers().size() != previousCluster.getDataInstanceTiers().size()) {
            return false;
        }
        Sets.SetView affectedTiers = Sets.union(diff.getDataInstanceTiers().keySet(), previousCluster.getDataInstanceTiers().keySet());
        Iterator iterator = affectedTiers.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            InstanceTier diffTier = (InstanceTier)diff.getDataInstanceTiers().get(i);
            InstanceTier previousTier = (InstanceTier)previousCluster.getDataInstanceTiers().get(i);
            if (diffTier == null && previousTier == null) continue;
            if (diffTier == null || previousTier == null) {
                return false;
            }
            if (diffTier.getName().equals(previousTier.getName()) && diffTier.getInstanceType().equals(previousTier.getInstanceType()) && diffTier.getPriority().equals(previousTier.getPriority()) && diffTier.getInstanceCount() >= previousTier.getInstanceCount()) continue;
            return false;
        }
        return true;
    }

    public Cluster maybeRemapDataInstanceTiersForBlueGreenDeployment(Cluster originalCluster, Cluster desiredCluster, UpdateType updateType) {
        return desiredCluster;
    }

    public String generateLoadRulesForBlueGreenDeployment(Collection<InstanceTier> oldTiers, Collection<InstanceTier> newTiers) {
        throw new UnsupportedOperationException();
    }

    public String getStatefulsetNameFromTier(Integer tier, Cluster cluster) {
        throw new UnsupportedOperationException();
    }

    public Pair<Integer, Integer> getDiskBaseEBSSizePair(InstanceTier tier) {
        throw new UnsupportedOperationException();
    }

    public boolean tierDiskSizeReduced(InstanceTier proposed, InstanceTier deployed) {
        throw new UnsupportedOperationException();
    }

    public boolean tierVolumeCountChanged(InstanceTier proposed, InstanceTier deployed) {
        throw new UnsupportedOperationException();
    }

    public Set<ImplyNodeType> getRunningTiers(Cluster cluster) {
        throw new UnsupportedOperationException();
    }

    public List<ImplyNodeType> getTiersSetDiff(Cluster fullSet, Cluster removedSet) {
        return fullSet.getDataInstanceTiers().entrySet().stream().filter(e -> {
            if (((InstanceTier)e.getValue()).getInstanceCount() == 0) {
                return false;
            }
            Map originalTiers = removedSet.getDataInstanceTiers();
            return !originalTiers.containsKey(e.getKey()) || ((InstanceTier)originalTiers.get(e.getKey())).getInstanceCount() == 0;
        }).map(e -> ImplyNodeType.dataFromTierInteger((int)((Integer)e.getKey()))).sorted(Comparator.comparingInt(nodeType -> nodeType.getTierNumber())).collect(Collectors.toList());
    }

    public String generateModifiedCoordinatorDynamicConfigurationForSaasAutoKill() {
        throw new UnsupportedOperationException();
    }

    public void maybeUpdateCoordinatorDynamicConfiguration(ManagerToolbox toolbox, PlanUpdateState planState, Deque<Stage> updatePlan, User principal) {
        throw new UnsupportedOperationException();
    }

    public boolean shouldModifyVolumes(Cluster cluster, ManagerToolbox toolbox) {
        throw new UnsupportedOperationException();
    }

    @Inject
    @Generated
    public ClusterUpdateHelper(ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, RefreshableConstants refreshableConstants) {
        this.clusterDataManager = clusterDataManager;
        this.entityStateDataManager = entityStateDataManager;
        this.applicationConfig = applicationConfig;
        this.objectMapper = objectMapper;
        this.refreshableConstants = refreshableConstants;
    }
}

