/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.imply.cloud.manager.util.AccountUsageHelper;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.BillingEntry;
import io.imply.cloud.model.BillingReportEntry;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.usage.UsageReportClusterEntry;
import io.imply.cloud.model.usage.UsageReportIntervalEntry;
import io.imply.cloud.model.usage.UsageReportNodeEntry;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.InstanceTypeHelper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class BillingReportManager {
    private static final String DELIMITER = ",";
    private static final double CU_FACTOR = 1000.0;
    private static final DateTime DEFAULT_START = new DateTime(2020, 2, 1, 0, 0, DateTimeZone.UTC);
    private static final List<String> HEADERS = ImmutableList.of((Object)"Cloud Vendor", (Object)"Region", (Object)"Cluster ID", (Object)"Cluster Name", (Object)"Account ID", (Object)"Account Name", (Object)"Date", (Object)"Total CU", (Object)"Total Processor Hours", (Object)"Max vCPU", (Object)"Max Cluster Size", (Object)"Clarity User", (Object[])new String[0]);
    private static final Pattern ACCOUNT_EXCLUSION_PATTERN = Pattern.compile("^(imply|big data com).*", 2);
    private final Provider<DateTime> currentDateTimeProvider;
    private final AccountDataManager accountDataManager;
    private final ClusterDataManager clusterDataManager;
    private final AccountUsageHelper accountUsageHelper;
    private final EntityStateDataManager entityStateDataManager;
    private final InstanceTypeHelper instanceTypeHelper;

    @Inject
    public BillingReportManager(Provider<DateTime> currentDateTimeProvider, AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, AccountUsageHelper accountUsageHelper, EntityStateDataManager entityStateDataManager, InstanceTypeHelper instanceTypeHelper) {
        this.currentDateTimeProvider = currentDateTimeProvider;
        this.accountDataManager = accountDataManager;
        this.clusterDataManager = clusterDataManager;
        this.accountUsageHelper = accountUsageHelper;
        this.entityStateDataManager = entityStateDataManager;
        this.instanceTypeHelper = instanceTypeHelper;
    }

    protected void generateReport(OutputStream out, String start, String end) {
        Interval interval = this.getAndValidateInterval(start, end);
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        writer.println(StringUtils.join(HEADERS, (String)DELIMITER));
        for (Account account : this.accountDataManager.getAll(DeletedVisibility.HIDE)) {
            if (ACCOUNT_EXCLUSION_PATTERN.matcher(account.getName()).matches()) continue;
            for (BillingReportEntry entry : this.getEntries(account, interval)) {
                writer.append(entry.getCloudVendor()).append(DELIMITER).append(entry.getRegion()).append(DELIMITER).append(entry.getClusterId()).append(DELIMITER).append(BillingReportManager.quote(entry.getClusterName())).append(DELIMITER).append(entry.getAccountId()).append(DELIMITER).append(BillingReportManager.quote(entry.getAccountName())).append(DELIMITER).append(entry.getDate()).append(DELIMITER).append(String.valueOf(entry.getTotalCU())).append(DELIMITER).append(String.valueOf(entry.getTotalProcessorHours())).append(DELIMITER).append(String.valueOf(entry.getMaxVCPU())).append(DELIMITER).append(String.valueOf(entry.getMaxClusterSize())).append(DELIMITER).append(entry.getClarityUser()).println();
            }
        }
    }

    private static String quote(String string) {
        return StringUtils.wrap((String)string, (char)'\"');
    }

    private Interval getAndValidateInterval(String start, String end) {
        DateTime currentDateTime = ((DateTime)this.currentDateTimeProvider.get()).withTimeAtStartOfDay();
        DateTime intervalStart = start == null ? DEFAULT_START : DateTime.parse((String)start, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
        DateTime intervalEnd = end == null ? currentDateTime : DateTime.parse((String)end, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
        Preconditions.checkState((!intervalStart.isBefore((ReadableInstant)DEFAULT_START) && !intervalStart.isAfter((ReadableInstant)currentDateTime) ? 1 : 0) != 0, (Object)"Start date must be after 2020-02-01 and before current date");
        Preconditions.checkState((!intervalEnd.isAfter((ReadableInstant)currentDateTime) && !intervalEnd.isBefore((ReadableInstant)DEFAULT_START) ? 1 : 0) != 0, (Object)"End date must be before current date and after 2020-02-01");
        return new Interval((ReadableInstant)intervalStart, (ReadableInstant)intervalEnd);
    }

    private List<BillingReportEntry> getEntries(Account account, Interval interval) {
        ArrayList<BillingReportEntry> entries = new ArrayList<BillingReportEntry>();
        List clusters = this.clusterDataManager.getAllWithAccountId(account.getAccountId(), DeletedVisibility.SHOW_ALL);
        Map<String, List<BillingEntry>> billingEntries = this.accountUsageHelper.getValidatedEntriesByCluster(account.getAccountId());
        for (Cluster cluster : clusters) {
            Info info = this.entityStateDataManager.get(cluster);
            for (Interval i : this.getIntervals(interval, Period.days((int)1))) {
                if (cluster.getCreated().isAfter((ReadableInstant)i.getEnd()) || info.getState().isTerminated() && info.getLastStateChange().isBefore((ReadableInstant)i.getStart())) continue;
                entries.add(this.getClusterReport(account, cluster, i, billingEntries));
            }
        }
        return entries;
    }

    private List<Interval> getIntervals(Interval interval, Period period) {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        DateTime current = interval.getStart();
        while (current.isBefore((ReadableInstant)interval.getEnd())) {
            DateTime end = current.plus((ReadablePeriod)period);
            if (end.isAfter((ReadableInstant)interval.getEnd())) {
                end = interval.getEnd();
            }
            intervals.add(new Interval((ReadableInstant)current, (ReadableInstant)end));
            current = end;
        }
        return intervals;
    }

    private BillingReportEntry getClusterReport(Account account, Cluster cluster, Interval interval, Map<String, List<BillingEntry>> billingEntries) {
        BillingReportEntry.Builder builder = BillingReportEntry.builder().cloudVendor(Platform.AWS.name()).region(account.getRegion().toString()).clusterId(cluster.getClusterId()).clusterName(cluster.getName()).accountId(account.getAccountId()).accountName(account.getName()).clarityUser((String)StringUtils.defaultIfBlank((CharSequence)account.getClarityUser(), (CharSequence)"N/A")).date(interval.getStart().toString("yyyy-MM-dd"));
        int totalCU = 0;
        int maxDailySize = 0;
        long vcpuSeconds = 0L;
        int maxVCPU = 0;
        List<UsageReportClusterEntry> usageReportClusterEntries = this.accountUsageHelper.getIntervalClusterUsage(account.getAccountId(), interval, (List<String>)ImmutableList.of((Object)cluster.getClusterId()), billingEntries);
        for (UsageReportClusterEntry entry : usageReportClusterEntries) {
            totalCU = (int)((long)totalCU + entry.getClusterMICU());
            for (UsageReportIntervalEntry intervalEntry : entry.getIntervals()) {
                int intervalVCPU = 0;
                int clusterSize = 0;
                for (Map.Entry nodeEntry : intervalEntry.getNodes().entrySet()) {
                    InstanceType instanceType = this.instanceTypeHelper.lookupInstanceType((ImplyNodeType)nodeEntry.getKey(), ((UsageReportNodeEntry)nodeEntry.getValue()).getType());
                    clusterSize += ((UsageReportNodeEntry)nodeEntry.getValue()).getCount().intValue();
                    vcpuSeconds += (long)(((UsageReportNodeEntry)nodeEntry.getValue()).getCount() * instanceType.getvCpu()) * intervalEntry.getIntervalSeconds();
                    intervalVCPU += ((UsageReportNodeEntry)nodeEntry.getValue()).getCount() * instanceType.getvCpu();
                }
                maxVCPU = Math.max(intervalVCPU, maxVCPU);
                maxDailySize = Math.max(clusterSize, maxDailySize);
            }
        }
        if (totalCU == 0) {
            maxDailySize = 0;
        }
        return builder.totalCU(Math.round((double)totalCU / 1000.0)).maxVCPU((long)maxVCPU).maxClusterSize((long)maxDailySize).totalProcessorHours(BigDecimal.valueOf(vcpuSeconds).divide(new BigDecimal(3600), 2, RoundingMode.HALF_UP).doubleValue()).build();
    }
}

