/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator.resources;

import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.configurator.AuthenticationManager;
import io.imply.cloud.configurator.resources.BaseResource;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="auth/v1")
public class AuthenticationResource
extends BaseResource {
    private static final Logger log = new Logger(AuthenticationResource.class);
    private final AuthenticationManager authenticationManager;

    @Inject
    public AuthenticationResource(AuthenticationManager authenticationManager, ClusterDataManager clusterDataManager, RefreshableConstants refreshableConstants) {
        super(clusterDataManager, refreshableConstants);
        this.authenticationManager = authenticationManager;
    }

    @GET
    @Path(value="certificates/{clusterId}")
    public Response getRootCertificate(@PathParam(value="clusterId") String clusterId) throws IOException {
        log.info("[getRootCertificate] request for cluster [%s]", new Object[]{clusterId});
        byte[] pemEncodedRootCertificate = this.authenticationManager.getPemEncodedRootCertificate(clusterId);
        if (pemEncodedRootCertificate == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)pemEncodedRootCertificate).type("application/x-pem-file").header("Content-Disposition", (Object)String.format("attachment; filename=\"%s.crt\"", clusterId)).build();
    }

    @POST
    @Path(value="keystore")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getKeystore(ConfigRequestBody body) throws IOException {
        log.info("[getKeystore] request with: %s", new Object[]{body});
        this.validateRequest(body, x -> {
            if (x.getClusterId() == null || x.getInstanceId() == null || x.getPrivateIpAddresses() == null || x.getPrivateIpAddresses().isEmpty() || x.getPrivateHostnames() == null || x.getPrivateHostnames().isEmpty() || x.getKey() == null) {
                throw new IllegalArgumentException("Fields [clusterId], [instanceId], [ipAddresses], [hostnames], and [key] required");
            }
        });
        return Response.ok((Object)this.authenticationManager.getServerKeyStore(body)).type("application/octet-stream").header("Content-Disposition", (Object)String.format("attachment; filename=\"%s.keystore.jks\"", body.getInstanceId())).build();
    }

    @POST
    @Path(value="truststore")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTruststore(ConfigRequestBody body) throws IOException {
        log.info("[getTruststore] request with: %s", new Object[]{body});
        this.validateRequest(body, x -> {
            if (x.getClusterId() == null || x.getInstanceId() == null || x.getKey() == null) {
                throw new IllegalArgumentException("Fields [clusterId], [instanceId], and [key] required");
            }
        });
        return Response.ok((Object)this.authenticationManager.getClientTrustStore(body)).type("application/octet-stream").header("Content-Disposition", (Object)String.format("attachment; filename=\"%s.truststore.jks\"", body.getInstanceId())).build();
    }

    @POST
    @Path(value="data-volume-encryption-key")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getDataVolumeEncryptionKey(ConfigRequestBody body) throws IOException {
        log.info("[getDataVolumeEncryptionKey] request with: %s", new Object[]{body});
        this.validateRequest(body, x -> {
            if (x.getClusterId() == null || x.getKey() == null) {
                throw new IllegalArgumentException("Fields [clusterId] and [key] required");
            }
        });
        return Response.ok((Object)this.authenticationManager.getDataVolumeEncryptionKey(body)).type("text/plain").build();
    }
}

