/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.configurator.resources.AuthenticationResource;
import io.imply.cloud.configurator.resources.ConfiguratorResource;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.PolyBind;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.http.RealHttpClientProvider;
import io.imply.cloud.server.guice.ServerRunnable;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.RefreshableConstantsFileUpdater;
import io.imply.cloud.util.RefreshableConstantsHttpUpdater;
import io.imply.cloud.util.RefreshableConstantsResourceUpdater;
import io.imply.cloud.util.RefreshableConstantsS3Updater;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="config-server", description="Runs the Imply Cloud Config Server")
public class CliConfigServer
extends ServerRunnable {
    private static final Logger log = new Logger(CliConfigServer.class);
    @Inject
    private ApplicationConfig applicationConfig;

    public CliConfigServer() {
        super(log);
    }

    protected List<? extends Module> getModules() {
        Preconditions.checkState((!this.applicationConfig.isManager() && this.applicationConfig.isConfigServer() ? 1 : 0) != 0, (Object)"ApplicationConfig incorrectly detecting [serviceName] (have the fully-qualified class names changed?)");
        return ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("config-server");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8082);
            binder.bind(ConfiguratorResource.class).asEagerSingleton();
            binder.bind(AuthenticationResource.class).asEagerSingleton();
            binder.bind(HttpClientProvider.class).to(RealHttpClientProvider.class).in(LazySingleton.class);
            PolyBind.createChoiceWithDefault((Binder)binder, (String)"refreshableConstants.type", (Key)Key.get(RefreshableConstantsUpdater.class), (String)(this.applicationConfig.isDevelopmentMode() ? "resource" : (this.applicationConfig.isAWS() ? "s3" : "http")));
            PolyBind.optionBinder((Binder)binder, (Key)Key.get(RefreshableConstantsUpdater.class)).addBinding((Object)"s3").to(RefreshableConstantsS3Updater.class).in(LazySingleton.class);
            PolyBind.optionBinder((Binder)binder, (Key)Key.get(RefreshableConstantsUpdater.class)).addBinding((Object)"http").to(RefreshableConstantsHttpUpdater.class).in(LazySingleton.class);
            PolyBind.optionBinder((Binder)binder, (Key)Key.get(RefreshableConstantsUpdater.class)).addBinding((Object)"resource").to(RefreshableConstantsResourceUpdater.class).in(LazySingleton.class);
            PolyBind.optionBinder((Binder)binder, (Key)Key.get(RefreshableConstantsUpdater.class)).addBinding((Object)"file").to(RefreshableConstantsFileUpdater.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, Server.class);
        });
    }
}

