/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.mask;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import net.logstash.logback.mask.FieldMasker;
import net.logstash.logback.mask.ValueMasker;

public class MaskingJsonGenerator
extends JsonGeneratorDelegate {
    public static final String MASK = "****";
    private static final SerializedString MASK_SERIALIZED = new SerializedString("****");
    private final Collection<FieldMasker> fieldMaskers;
    private final Collection<ValueMasker> valueMaskers;
    private int maskDepth = 0;

    public MaskingJsonGenerator(JsonGenerator delegate, Collection<FieldMasker> fieldMaskers, Collection<ValueMasker> valueMaskers) {
        super(delegate, false);
        this.fieldMaskers = fieldMaskers == null ? Collections.emptyList() : fieldMaskers;
        this.valueMaskers = valueMaskers == null ? Collections.emptyList() : valueMaskers;
    }

    public void writeArray(int[] array, int offset, int length) throws IOException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
    }

    public void writeArray(long[] array, int offset, int length) throws IOException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
    }

    public void writeArray(double[] array, int offset, int length) throws IOException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
    }

    public void writeFieldName(SerializableString name) throws IOException {
        this.writeFieldName(() -> super.writeFieldName(name));
    }

    public void writeFieldName(String name) throws IOException {
        this.writeFieldName(() -> super.writeFieldName(name));
    }

    public void writeFieldId(long id) throws IOException {
        this.writeFieldName(() -> super.writeFieldId(id));
    }

    private void writeFieldName(ThrowingRunnable<IOException> doWriteFieldName) throws IOException {
        if (this.maskingInProgress()) {
            this.decrementMaskDepth();
        }
        if (this.maskingInProgress()) {
            this.incrementMaskDepth();
        } else {
            doWriteFieldName.run();
            Object maskedValue = this.getMaskedValueForCurrentPath();
            if (maskedValue != null) {
                this.delegate.writeObject(maskedValue);
                this.incrementMaskDepth();
            }
        }
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeBinary(b64variant, data, offset, len);
        }
    }

    public void writeBinary(byte[] data) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeBinary(data);
        }
    }

    public void writeBinary(byte[] data, int offset, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeBinary(data, offset, len);
        }
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException {
        if (!this.maskingInProgress()) {
            return super.writeBinary(b64variant, data, dataLength);
        }
        return this.readAndDiscard(data);
    }

    public int writeBinary(InputStream data, int dataLength) throws IOException {
        if (!this.maskingInProgress()) {
            return super.writeBinary(data, dataLength);
        }
        return this.readAndDiscard(data);
    }

    private int readAndDiscard(InputStream data) throws IOException {
        int bytesRead = 0;
        while (data.read() != -1) {
            ++bytesRead;
        }
        return bytesRead;
    }

    public void writeBoolean(boolean state) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeBoolean(state);
        }
    }

    public void writeEmbeddedObject(Object object) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeEmbeddedObject(object);
        }
    }

    public void writeNull() throws IOException {
        if (!this.maskingInProgress()) {
            super.writeNull();
        }
    }

    public void writeNumber(BigDecimal v) throws IOException {
        this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public void writeNumber(BigInteger v) throws IOException {
        this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public void writeNumber(double v) throws IOException {
        this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public void writeNumber(float v) throws IOException {
        this.writePotentiallyMaskedValue(Float.valueOf(v), () -> super.writeNumber(v));
    }

    public void writeNumber(int v) throws IOException {
        this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public void writeNumber(short v) throws IOException {
        this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public void writeNumber(long v) throws IOException {
        this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public void writeNumber(String encodedValue) throws IOException {
        this.writePotentiallyMaskedValue(encodedValue, () -> super.writeNumber(encodedValue));
    }

    public void writeObjectId(Object id) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeObjectId(id);
        }
    }

    public void writeObjectRef(Object id) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeObjectRef(id);
        }
    }

    public void writeOmittedField(String fieldName) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeOmittedField(fieldName);
        }
    }

    public void writeRaw(char c) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRaw(c);
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRaw(text, offset, len);
        }
    }

    public void writeRaw(String text) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRaw(text);
        }
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRaw(text, offset, len);
        }
    }

    public void writeRaw(SerializableString raw) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRaw(raw);
        }
    }

    public void writeRawValue(String text) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRawValue(text);
        }
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRawValue(text, offset, len);
        }
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRawValue(text, offset, len);
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeRawUTF8String(text, offset, length);
        }
    }

    public void writeStartArray(int size) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartArray(size);
        }
    }

    public void writeStartArray() throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartArray();
        }
    }

    public void writeStartArray(Object forValue) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartArray(forValue);
        }
    }

    public void writeStartArray(Object forValue, int size) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartArray(forValue, size);
        }
    }

    public void writeStartObject() throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartObject();
        } else {
            this.incrementMaskDepth();
        }
    }

    public void writeStartObject(Object forValue) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartObject(forValue);
        } else {
            this.incrementMaskDepth();
        }
    }

    public void writeStartObject(Object forValue, int size) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeStartObject(forValue, size);
        } else {
            this.incrementMaskDepth();
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writePotentiallyMaskedValue(new String(text, offset, len), () -> super.writeString(text, offset, len));
    }

    public void writeString(String text) throws IOException {
        this.writePotentiallyMaskedValue(text, () -> super.writeString(text));
    }

    public void writeString(SerializableString text) throws IOException {
        this.writePotentiallyMaskedValue(text.getValue(), () -> super.writeString(text));
    }

    public void writeString(Reader reader, int len) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeString(reader, len);
        }
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writePotentiallyMaskedValue(new String(text, offset, length, StandardCharsets.UTF_8), () -> super.writeUTF8String(text, offset, length));
    }

    public void writeTypeId(Object id) throws IOException {
        if (!this.maskingInProgress()) {
            super.writeTypeId(id);
        }
    }

    public void writeEndArray() throws IOException {
        if (!this.maskingInProgress()) {
            super.writeEndArray();
        }
    }

    public void writeEndObject() throws IOException {
        if (this.maskingInProgress()) {
            this.decrementMaskDepth();
        }
        if (!this.maskingInProgress()) {
            super.writeEndObject();
        }
    }

    private Object getMaskedValueForCurrentPath() {
        JsonStreamContext context = this.getOutputContext();
        for (FieldMasker fieldMasker : this.fieldMaskers) {
            Object maskedValue = fieldMasker.mask(context);
            if (maskedValue == null) continue;
            return maskedValue;
        }
        return null;
    }

    private Object getMaskedValueForCurrentPathAndValue(Object value) {
        JsonStreamContext context = this.getOutputContext();
        for (ValueMasker valueMasker : this.valueMaskers) {
            Object maskedValue = valueMasker.mask(context, value);
            if (maskedValue == null) continue;
            return maskedValue;
        }
        return null;
    }

    private void writePotentiallyMaskedValue(Object value, ThrowingRunnable<IOException> doWriteUnmaskedValue) throws IOException {
        if (!this.maskingInProgress()) {
            Object maskedValue = this.getMaskedValueForCurrentPathAndValue(value);
            if (maskedValue != null) {
                this.delegate.writeObject(maskedValue);
            } else {
                doWriteUnmaskedValue.run();
            }
        }
    }

    private void incrementMaskDepth() {
        ++this.maskDepth;
    }

    private void decrementMaskDepth() {
        --this.maskDepth;
    }

    boolean maskingInProgress() {
        return this.maskDepth != 0;
    }

    @FunctionalInterface
    private static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }
}

