/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.imply.cloud.grove.GroveClient;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.NodeHelper;
import io.imply.cloud.manager.NoticeManager;
import io.imply.cloud.manager.notice.cluster.ReloadNodeNotice;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OnPremNodeHelper
implements NodeHelper,
OnPremHelpers {
    private static final Logger log = new Logger(OnPremNodeHelper.class);
    private final AccountDataManager accountDataManager;
    private final GroveClient groveClient;
    private final NoticeManager noticeManager;
    private final EntityStateDataManager entityStateDataManager;

    @Inject
    public OnPremNodeHelper(AccountDataManager accountDataManager, GroveClient groveClient, NoticeManager noticeManager, EntityStateDataManager entityStateDataManager) {
        this.accountDataManager = accountDataManager;
        this.groveClient = groveClient;
        this.noticeManager = noticeManager;
        this.entityStateDataManager = entityStateDataManager;
    }

    public void restartNode(Cluster cluster, String address) {
        Account account = this.accountDataManager.get(cluster.getAccountId());
        Preconditions.checkArgument((account.getGroveServer() != null ? 1 : 0) != 0, (String)"No [groveServer] configuration found for accountId [%s]", (Object)account.getAccountId());
        List nodes = this.groveClient.getGroveNodes(account.getGroveServer(), true);
        Optional<Node> nodeOpt = nodes.stream().filter(x -> address.equals(x.getAddress())).findFirst();
        if (!nodeOpt.isPresent()) {
            throw new IAE("Node [%s] is not online and cannot be restarted", new Object[]{address});
        }
        log.info("Queuing notice to restart node with hostname [%s] address [%s]", new Object[]{nodeOpt.get().getHostname(), nodeOpt.get().getAddress()});
        Info info = this.entityStateDataManager.get(cluster);
        this.noticeManager.queueNotice(ReloadNodeNotice.class, info, (Map)ImmutableMap.of((Object)"nodeAddress", (Object)nodeOpt.get().getAddress()), false);
    }
}

