/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.PlanUpdateState;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.User;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.OnPremClusterUpdateHelper;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Pair;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OnPremKubernetesClusterUpdateHelper
extends OnPremClusterUpdateHelper {
    @Inject
    public OnPremKubernetesClusterUpdateHelper(ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, ClusterNodesDataManager clusterNodesDataManager, RefreshableConstants refreshableConstants) {
        super(clusterDataManager, entityStateDataManager, applicationConfig, objectMapper, clusterNodesDataManager, refreshableConstants);
    }

    @Override
    protected void getSupportedUpdatesForClusterDiff(Cluster diff, Cluster previousCluster, List<Set<UpdateDetails>> updateDetailsList) {
        super.getSupportedUpdatesForClusterDiff(diff, previousCluster, updateDetailsList);
        if (diff == null) {
            return;
        }
        if (!this.canDataInstanceTierChangeSupportRolling(diff, previousCluster)) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30)));
        }
    }

    @VisibleForTesting
    boolean canDataInstanceTierChangeSupportRolling(Cluster diff, Cluster previousCluster) {
        if (diff == null || previousCluster == null || diff.getDataInstanceTiers() == null || previousCluster.getDataInstanceTiers() == null) {
            return true;
        }
        Sets.SetView affectedTiers = Sets.union(diff.getDataInstanceTiers().keySet(), previousCluster.getDataInstanceTiers().keySet());
        Iterator iterator = affectedTiers.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            InstanceTier diffTier = (InstanceTier)diff.getDataInstanceTiers().get(i);
            InstanceTier previousTier = (InstanceTier)previousCluster.getDataInstanceTiers().get(i);
            if (previousTier == null || diffTier == null || diffTier.getInstanceType().equals(previousTier.getInstanceType()) || diffTier.getInstanceCount() != 1) continue;
            return false;
        }
        return true;
    }

    public Pair<Integer, Integer> getDiskBaseEBSSizePair(InstanceTier tier) {
        InstanceType instanceType = this.refreshableConstants.getSupportedDataInstanceTypes().stream().filter(x -> tier.getInstanceType().equals(x.getInstanceType())).findFirst().orElseThrow(() -> new ISE("Could not find data node definition", new Object[0]));
        return Pair.of((Object)(instanceType.getInstanceType().endsWith("-pd") ? instanceType.getDiskInGb() : 0), (Object)(instanceType.getInstanceType().endsWith("-pd") ? instanceType.getBaseEBSVolumeSizeInGB() : Constants.DEFAULT_VOLUME_SIZE_GB));
    }

    public String getStatefulsetNameFromTier(Integer tier, Cluster cluster) {
        String prefix = HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig) + "-imply-data";
        switch (tier) {
            case 1: {
                return prefix;
            }
            case 2: {
                return prefix + "-two";
            }
            case 3: {
                return prefix + "-three";
            }
        }
        return String.format("%s-%d", prefix, tier);
    }

    public void maybeUpdateCoordinatorDynamicConfiguration(ManagerToolbox toolbox, PlanUpdateState planState, Deque<Stage> updatePlan, User principal) {
        String config = this.generateModifiedCoordinatorDynamicConfiguration(planState.getCoordinatorDynamicConfiguration(), 200, 2000);
        if (config == null) {
            return;
        }
        updatePlan.add((Stage)new ModifyCoordinatorDynamicConfigurationStage(toolbox, planState.getClusterId(), null, planState.getMasterHostAddresses(), config, Boolean.valueOf(false), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), String.format("Temporarily setting [maxSegmentsToMove=%d] and [replicationThrottleLimit=%d] for rolling update", 200, 2000)));
        planState.setCoordinatorDynamicConfigurationModified(true);
    }

    public Set<ImplyNodeType> getRunningTiers(Cluster cluster) {
        return cluster.getDataInstanceTiers().entrySet().stream().filter(e -> ((InstanceTier)e.getValue()).getInstanceCount() > 0).map(e -> ImplyNodeType.dataFromTierInteger((int)((Integer)e.getKey()))).collect(Collectors.toSet());
    }
}

