/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.grove.GroveClient;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.config.OnPremKubernetesManagerConfig;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.KubernetesUtils;
import io.imply.cloud.onprem.util.OnPremClusterStackHelper;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.InstanceHealthDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class OnPremKubernetesClusterStackHelper
extends OnPremClusterStackHelper {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesClusterStackHelper.class);
    private final K8sUtilsProvider k8sUtilsProvider;
    private final ApplicationConfig applicationConfig;
    private final OnPremKubernetesManagerConfig onPremKubernetesManagerConfig;

    @Inject
    public OnPremKubernetesClusterStackHelper(AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, InstanceHealthDataManager instanceHealthDataManager, GroveClient groveClient, ApplicationConfig applicationConfig, ClusterNodesHelper clusterNodesHelper, K8sUtilsProvider k8sUtilsProvider, OnPremKubernetesManagerConfig onPremKubernetesManagerConfig) {
        super(accountDataManager, clusterDataManager, instanceHealthDataManager, groveClient, applicationConfig, clusterNodesHelper);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.applicationConfig = applicationConfig;
        this.onPremKubernetesManagerConfig = onPremKubernetesManagerConfig;
    }

    @Override
    protected Map<String, String> getLoadBalancers(String clusterId) {
        ImmutableMap toReturn;
        List<Ingress> ingresses;
        List<Service> services;
        KubernetesUtils kubernetesUtils = this.k8sUtilsProvider.getKubernetesUtilsFromCluster(clusterId);
        Cluster cluster = this.clusterDataManager.get(clusterId);
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig);
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig);
        try {
            services = kubernetesUtils.getServicesForCluster(namespace, releaseName);
            ingresses = kubernetesUtils.getIngressesForCluster(namespace, releaseName);
        }
        catch (KubernetesClientException e) {
            log.info((Throwable)e, "Could not determine services for cluster [%s]", new Object[]{clusterId});
            return null;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Optional<String> internalIp = services.stream().filter(service -> service.getMetadata() != null && service.getMetadata().getName() != null && service.getMetadata().getName().endsWith("imply-query") && service.getStatus() != null && service.getStatus().getLoadBalancer() != null && service.getStatus().getLoadBalancer().getIngress() != null).flatMap(s -> s.getStatus().getLoadBalancer().getIngress().stream()).filter(i -> i.getIp() != null).map(LoadBalancerIngress::getIp).findFirst();
        if (internalIp.isPresent()) {
            mapBuilder.put((Object)"queryInternal", (Object)internalIp.get());
        }
        if (!ingresses.isEmpty() && StringUtils.isNotBlank((CharSequence)this.onPremKubernetesManagerConfig.getIngressHost())) {
            mapBuilder.put((Object)"queryExternal", (Object)String.format("https://%s/%s", this.onPremKubernetesManagerConfig.getIngressHost(), clusterId));
        }
        if ((toReturn = mapBuilder.build()).isEmpty()) {
            return null;
        }
        return toReturn;
    }

    @Generated
    protected K8sUtilsProvider getK8sUtilsProvider() {
        return this.k8sUtilsProvider;
    }

    @Override
    @Generated
    protected ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    @Generated
    protected OnPremKubernetesManagerConfig getOnPremKubernetesManagerConfig() {
        return this.onPremKubernetesManagerConfig;
    }
}

