/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.manager.ClusterUpdateHelper;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OnPremClusterUpdateHelper
extends ClusterUpdateHelper
implements OnPremHelpers {
    private final ClusterNodesDataManager clusterNodesDataManager;
    protected final ApplicationConfig applicationConfig;

    @Inject
    public OnPremClusterUpdateHelper(ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ApplicationConfig applicationConfig, ObjectMapper objectMapper, ClusterNodesDataManager clusterNodesDataManager, RefreshableConstants refreshableConstants) {
        super(clusterDataManager, entityStateDataManager, applicationConfig, objectMapper, refreshableConstants);
        this.clusterNodesDataManager = clusterNodesDataManager;
        this.applicationConfig = applicationConfig;
    }

    public boolean canSupportRollingUpdates(Cluster cluster) {
        ClusterNodes clusterNodes;
        if (!this.applicationConfig.isKubernetesMode()) {
            Preconditions.checkArgument((cluster.getMasterInstanceCount() == null ? 1 : 0) != 0, (Object)"Sanity check failed: cluster.masterInstanceCount should be null");
        }
        if ((clusterNodes = this.clusterNodesDataManager.getOrNull(cluster.getClusterId())) == null) {
            return false;
        }
        List dataTiers = ClusterNodesHelper.getAllDataTiers((Map)clusterNodes.getNodes());
        boolean dataTiersCanSupportRollingUpdate = dataTiers.stream().map(tier -> ClusterNodesHelper.getSortedHosts((Map)clusterNodes.getNodes(), (Collection)ImmutableList.of((Object)tier))).allMatch(hosts -> hosts.size() > 1 || hosts.isEmpty());
        return ClusterNodesHelper.getSortedMasterHosts((Map)clusterNodes.getNodes()).size() > 1 && ClusterNodesHelper.getSortedQueryHosts((Map)clusterNodes.getNodes()).size() > 1 && dataTiersCanSupportRollingUpdate && !ClusterNodesHelper.getSortedDataHosts((Map)clusterNodes.getNodes()).isEmpty();
    }

    protected void getSupportedUpdatesForClusterDiff(Cluster diff, Cluster previousCluster, List<Set<UpdateDetails>> updateDetailsList) {
        super.getSupportedUpdatesForClusterDiff(diff, previousCluster, updateDetailsList);
        if (diff == null) {
            return;
        }
        ClusterNodes nodes = this.clusterNodesDataManager.getOrNull(previousCluster.getClusterId());
        if (updateDetailsList.stream().flatMap(Collection::stream).map(UpdateDetails::getEstimatedTimeInMinutes).filter(Objects::nonNull).reduce(0, Integer::sum) > 0 && nodes != null && nodes.getNodes().values().stream().anyMatch(x -> x.getNodeTypes().size() > 1)) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)Integer.MAX_VALUE, (String)"Rolling updates are not supported for clusters with more than one Imply service (master, query, data) on a single node.")));
        }
    }

    protected void getSupportedUpdatesForClusterNodesDiff(ClusterNodes diff, ClusterNodes previousClusterNodes, Cluster cluster, List<Set<UpdateDetails>> updateDetailsList) {
        if (diff.getClusterId() != null) {
            updateDetailsList.add(OnPremClusterUpdateHelper.buildUnsupportedUpdate((String)"Cluster ID cannot be updated."));
        }
        if (diff.getNodes() == null) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)new UpdateDetails(UpdateType.NO_CHANGE, null)));
            return;
        }
        HashMap previousNodes = previousClusterNodes.getNodes() == null ? new HashMap() : new HashMap(previousClusterNodes.getNodes());
        HashMap<String, NodeConfiguration> addedNodes = new HashMap<String, NodeConfiguration>();
        HashMap<String, NodeConfiguration> modifiedNodes = new HashMap<String, NodeConfiguration>();
        HashMap removedNodes = new HashMap(previousNodes);
        for (Map.Entry diffEntry : diff.getNodes().entrySet()) {
            if (!previousNodes.containsKey(diffEntry.getKey())) {
                addedNodes.put((String)diffEntry.getKey(), (NodeConfiguration)diffEntry.getValue());
            } else if (!((NodeConfiguration)diffEntry.getValue()).equals(previousNodes.get(diffEntry.getKey()))) {
                modifiedNodes.put((String)diffEntry.getKey(), (NodeConfiguration)diffEntry.getValue());
            }
            removedNodes.remove(diffEntry.getKey());
        }
        if (!addedNodes.isEmpty()) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)5)));
        }
        if (!ClusterNodesHelper.getSortedMasterHosts(removedNodes).isEmpty()) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)5)));
        }
        if (!ClusterNodesHelper.getSortedQueryHosts(removedNodes).isEmpty()) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)5)));
        }
        if (!ClusterNodesHelper.getSortedDataHosts(removedNodes).isEmpty()) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999)));
        }
        for (Map.Entry entry : modifiedNodes.entrySet()) {
            ImmutableSet originalNodeTypes;
            Set newNodeTypes = ((NodeConfiguration)entry.getValue()).getNodeTypes();
            Object object = originalNodeTypes = previousNodes.get(entry.getKey()) == null || ((NodeConfiguration)previousNodes.get(entry.getKey())).getNodeTypes() == null ? ImmutableSet.of() : ((NodeConfiguration)previousNodes.get(entry.getKey())).getNodeTypes();
            if (originalNodeTypes.size() > 1 || newNodeTypes.size() > 1) {
                updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)Integer.MAX_VALUE, (String)"Rolling updates are not supported for clusters with more than one Imply service (master, query, data) on a single node.")));
                continue;
            }
            ImplyNodeType newNodeType = (ImplyNodeType)newNodeTypes.stream().findFirst().orElseThrow(IllegalStateException::new);
            ImplyNodeType originalNodeType = originalNodeTypes.stream().findFirst().orElse(ImplyNodeType.UNKNOWN);
            if (previousNodes.values().stream().filter(n -> n != null && n.getNodeTypes() != null && n.getNodeTypes().contains(originalNodeType)).count() == 1L && diff.getNodes().values().stream().filter(n -> n.getNodeTypes().contains(newNodeType)).count() == 1L) {
                updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)5)));
                continue;
            }
            if (newNodeTypes.contains(ImplyNodeType.MASTER) && !originalNodeTypes.contains(ImplyNodeType.MASTER) || originalNodeTypes.contains(ImplyNodeType.MASTER) && !newNodeTypes.contains(ImplyNodeType.MASTER)) {
                updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)5)));
            }
            if (newNodeTypes.contains(ImplyNodeType.QUERY) && !originalNodeTypes.contains(ImplyNodeType.QUERY) || originalNodeTypes.contains(ImplyNodeType.QUERY) && !newNodeTypes.contains(ImplyNodeType.QUERY)) {
                updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)5)));
            }
            if (newNodeTypes.stream().anyMatch(ImplyNodeType::isDataType) && originalNodeTypes.stream().noneMatch(ImplyNodeType::isDataType)) {
                updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.rolling((int)5)));
            }
            if (!originalNodeTypes.stream().anyMatch(ImplyNodeType::isDataType) || !newNodeTypes.stream().noneMatch(ImplyNodeType::isDataType)) continue;
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)UpdateDetails.hard((int)30), (Object)UpdateDetails.rolling((int)999)));
        }
        if (updateDetailsList.isEmpty()) {
            updateDetailsList.add((Set<UpdateDetails>)ImmutableSet.of((Object)new UpdateDetails(UpdateType.NO_CHANGE, null)));
        }
    }

    public int getTotalMICU(String accountId, Cluster proposedCluster) {
        return 0;
    }
}

