/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.inject.Inject;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentCondition;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressList;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class KubernetesUtils {
    @Generated
    private static final Logger log = Logger.from(KubernetesUtils.class);
    private static final String RELEASE_SELECTOR = "app.kubernetes.io/instance=%s";
    private static final String DEPLOYMENT_PROGRESSING = "Progressing";
    private static final String TIMED_OUT_REASON = "ProgressDeadlineExceeded";
    private static final String ROLLING_UPDATE_TYPE = "RollingUpdate";
    private static final String DRUID_PEON_JOB_LABEL = "druid.k8s.peons";
    private static final String DRUID_TASK_TYPE_LABEL = "druid.task.type";
    static final String[] EXCLUDED_TASK_TYPES = new String[]{"compact", "index", "index_parallel", "index_hadoop", "kill", "move", "archive", "restore", "single_phase_sub_task", "index_sub", "partial_index_generate", "partial_dimension_cardinality", "partial_range_index_generate", "partial_dimension_distribution", "partial_index_generic_merge", "query_controller", "query_worker"};
    public static final String RETAIN_STATEFULSET_PATCH = "[{\"op\":\"add\",\"path\":\"/metadata/annotations/helm.sh~1resource-policy\",\"value\":\"keep\"}]";
    public static final String REMOVE_RETAIN_STATEFULSET_PATCH = "[{\"op\":\"remove\",\"path\":\"/metadata/annotations/helm.sh~1resource-policy\"}]";
    private final KubernetesClient client;

    public ClusterOperationResult getDeploymentsStatus(String releaseName, String namespace) {
        DeploymentList deploymentList = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list();
        if (deploymentList.getItems().isEmpty()) {
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, "Waiting for Deployments to start");
        }
        for (Deployment deployment : deploymentList.getItems()) {
            ClusterOperationResult result = this.getDeploymentStatus(deployment);
            if (ClusterOperationResult.Status.COMPLETE.equals((Object)result.getStatus())) continue;
            return result;
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, "All Deployments successful");
    }

    public ClusterOperationResult getDeploymentStatus(Deployment deployment) {
        String name = deployment.getMetadata().getName();
        DeploymentStatus status = deployment.getStatus();
        if (deployment.getMetadata().getGeneration() <= (Long)ObjectUtils.defaultIfNull((Object)status.getObservedGeneration(), (Object)0L)) {
            Optional<DeploymentCondition> condition = status.getConditions().stream().filter(cond -> DEPLOYMENT_PROGRESSING.equals(cond.getType())).findFirst();
            if (condition.isPresent() && TIMED_OUT_REASON.equals(condition.get().getReason())) {
                return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, String.format("Deployment %s timed out", name));
            }
            int updatedReplicas = (Integer)ObjectUtils.defaultIfNull((Object)status.getUpdatedReplicas(), (Object)0);
            if (deployment.getSpec().getReplicas() != null && updatedReplicas < deployment.getSpec().getReplicas()) {
                return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("%d/%d replicas in Deployment %s updated", updatedReplicas, deployment.getSpec().getReplicas(), name));
            }
            if (status.getReplicas() > updatedReplicas) {
                return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("%d old replicas in Deployment %s terminating", status.getReplicas() - updatedReplicas, name));
            }
            int availableReplicas = (Integer)ObjectUtils.defaultIfNull((Object)status.getAvailableReplicas(), (Object)0);
            if (availableReplicas < updatedReplicas) {
                return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("%d/%d replicas in Deployment %s available", availableReplicas, updatedReplicas, name));
            }
            return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, String.format("Deployment %s successful", name));
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("Deployment %s waiting for update", name));
    }

    public ClusterOperationResult getStatefulSetsStatus(String releaseName, String namespace) {
        return this.getStatefulSetsStatus(releaseName, namespace, false);
    }

    public ClusterOperationResult getStatefulSetsStatus(String releaseName, String namespace, Boolean completedOnEmpty) {
        StatefulSetList statefulSetList = (StatefulSetList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list();
        if (CollectionUtils.isEmpty((Collection)statefulSetList.getItems())) {
            return completedOnEmpty != false ? new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, "All StatefulSets successful") : new ClusterOperationResult(ClusterOperationResult.Status.PENDING, "Waiting for StatefulSets to start");
        }
        for (StatefulSet statefulSet : statefulSetList.getItems()) {
            ClusterOperationResult result = this.getStatefulSetStatus(statefulSet);
            if (ClusterOperationResult.Status.COMPLETE.equals((Object)result.getStatus())) continue;
            return result;
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, "All StatefulSets successful");
    }

    public ClusterOperationResult getStatefulSetStatus(StatefulSet statefulSet) {
        String name = statefulSet.getMetadata().getName();
        StatefulSetStatus status = statefulSet.getStatus();
        if (!ROLLING_UPDATE_TYPE.equals(statefulSet.getSpec().getUpdateStrategy().getType())) {
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, String.format("StatefulSet %s has invalid update type %s", name, statefulSet.getSpec().getUpdateStrategy().getType()));
        }
        long observedGeneration = (Long)ObjectUtils.defaultIfNull((Object)status.getObservedGeneration(), (Object)0L);
        if (observedGeneration == 0L || statefulSet.getMetadata().getGeneration() > observedGeneration) {
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("StatefulSet %s waiting for update", name));
        }
        int readyReplicas = (Integer)ObjectUtils.defaultIfNull((Object)status.getReadyReplicas(), (Object)0);
        if (statefulSet.getSpec().getReplicas() != null && readyReplicas < statefulSet.getSpec().getReplicas()) {
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("%d/%d pods in StatefulSet %s ready", readyReplicas, statefulSet.getSpec().getReplicas(), name));
        }
        if (statefulSet.getSpec().getUpdateStrategy().getRollingUpdate() != null) {
            if (statefulSet.getSpec().getReplicas() != null && statefulSet.getSpec().getUpdateStrategy().getRollingUpdate().getPartition() != null && (Integer)ObjectUtils.defaultIfNull((Object)status.getUpdatedReplicas(), (Object)0) < statefulSet.getSpec().getReplicas() - statefulSet.getSpec().getUpdateStrategy().getRollingUpdate().getPartition()) {
                return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("%d/%d pods in StatefulSet %s updated", ObjectUtils.defaultIfNull((Object)status.getUpdatedReplicas(), (Object)0), statefulSet.getSpec().getReplicas() - statefulSet.getSpec().getUpdateStrategy().getRollingUpdate().getPartition(), name));
            }
            return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, String.format("StatefulSet %s successful", name));
        }
        if (!status.getUpdateRevision().equals(status.getCurrentRevision())) {
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("%d/%d pods in StatefulSet %s updated", status.getUpdatedReplicas(), status.getReplicas(), name));
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, String.format("StatefulSet %s successful", name));
    }

    public List<Pod> getPodsOfRelease(String namespace, String labelSelector) {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabelSelector(labelSelector)).list()).getItems();
    }

    public List<Pod> getPodsOfClusterRelease(String releaseName, String namespace) {
        return this.getPodsOfRelease(namespace, String.format(RELEASE_SELECTOR, releaseName));
    }

    public List<Pod> getPodsOfAccountRelease(String releaseName, String namespace) {
        return this.getPodsOfRelease(namespace, String.format("release=%s", releaseName));
    }

    public List<Pod> getPodsOfStatefulSet(String statefulSetName, String namespace) {
        StatefulSet statefulSet = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withName(statefulSetName)).get();
        if (statefulSet == null) {
            throw new KubernetesClientException(String.format("statefulset with name %s not found", statefulSetName));
        }
        String labelSelector = statefulSet.getSpec().getSelector().getMatchLabels().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
        return this.getPodsOfRelease(namespace, labelSelector);
    }

    public List<Pod> getPodsOfStatefulSetOfClusterRelease(String releaseName, String namespace) {
        List statefulSets = ((StatefulSetList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list()).getItems();
        if (CollectionUtils.isEmpty((Collection)statefulSets)) {
            throw new KubernetesClientException(String.format("no statefulsets were found with release %s", releaseName));
        }
        return statefulSets.stream().map(sts -> {
            String labelSelector = sts.getSpec().getSelector().getMatchLabels().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
            try {
                return this.getPodsOfRelease(namespace, labelSelector);
            }
            catch (KubernetesClientException e) {
                throw new ISE("Unable to get pods of statefulset [%s] in namespace [%s]", new Object[]{sts.getMetadata().getName(), namespace});
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Service> getServicesForCluster(String namespace, String releaseName) {
        String labelSelector = String.format(RELEASE_SELECTOR, releaseName);
        return ((ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withLabelSelector(labelSelector)).list()).getItems();
    }

    public List<Ingress> getIngressesForCluster(String namespace, String releaseName) {
        String labelSelector = String.format(RELEASE_SELECTOR, releaseName);
        return ((IngressList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.network().v1().ingresses().inNamespace(namespace)).withLabelSelector(labelSelector)).list()).getItems();
    }

    public void createOrUpdateNamespace(String namespace, String accountId) {
        Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().editMetadata().withName(namespace)).addToLabels("imply.io/account", accountId)).endMetadata()).build();
        ((Resource)this.client.namespaces().resource((Object)ns)).fieldManager("imply-manager").serverSideApply();
    }

    public void deleteNamespace(String namespace) {
        ((GracePeriodConfigurable)((Resource)this.client.namespaces().withName(namespace)).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
    }

    public Namespace getNamespace(String namespace) {
        return (Namespace)((Resource)this.client.namespaces().withName(namespace)).get();
    }

    public void deletePVCsForRelease(String namespace, String releaseName) {
        ((PropagationPolicyConfigurable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.persistentVolumeClaims().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).withGracePeriod(0L)).delete();
    }

    public void deleteStatefulSetWithOrphanForRelease(String namespace, String releaseName) {
        ((GracePeriodConfigurable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).withPropagationPolicy(DeletionPropagation.ORPHAN)).delete();
    }

    public void deleteStatefulSetWithPVC(String namespace, String releaseName) {
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).delete();
        this.deletePVCsForRelease(namespace, releaseName);
    }

    public void retainStatefulsetsAfterHelmOperation(String namespace, String releaseName, List<String> statefulsetNames) {
        for (String name : statefulsetNames) {
            ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withName(name)).patch(PatchContext.of((PatchType)PatchType.JSON), RETAIN_STATEFULSET_PATCH);
        }
    }

    private List<StatefulSet> getRetainedStatefulsets(String namespace, String releaseName) {
        StatefulSetList statefulSetList = (StatefulSetList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list();
        return CollectionUtils.emptyIfNull((Collection)statefulSetList.getItems()).stream().filter(statefulSet -> Optional.ofNullable(statefulSet.getMetadata()).map(ObjectMeta::getAnnotations).map(a -> (String)a.get("helm.sh/resource-policy")).orElse("").equals("keep")).collect(Collectors.toList());
    }

    public void removeRetainStatefulsetsAnnotation(String namespace, String releaseName) {
        for (StatefulSet statefulSet : this.getRetainedStatefulsets(namespace, releaseName)) {
            ((RollableScalableResource)this.client.apps().statefulSets().resource((Object)statefulSet)).patch(PatchContext.of((PatchType)PatchType.JSON), REMOVE_RETAIN_STATEFULSET_PATCH);
        }
    }

    private void forceDeleteStatefulsets(List<StatefulSet> statefulSets, String namespace, boolean deletePVC) {
        for (StatefulSet statefulSet : statefulSets) {
            ((PropagationPolicyConfigurable)((RollableScalableResource)this.client.apps().statefulSets().resource((Object)statefulSet)).withGracePeriod(0L)).delete();
            String labelSelector = statefulSet.getSpec().getSelector().getMatchLabels().entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(","));
            ((PropagationPolicyConfigurable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabelSelector(labelSelector)).withGracePeriod(0L)).delete();
            if (!deletePVC) continue;
            ((PropagationPolicyConfigurable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.persistentVolumeClaims().inNamespace(namespace)).withLabelSelector(labelSelector)).withGracePeriod(0L)).delete();
        }
    }

    public void forceDeleteStatefulsets(String namespace, String releaseName, boolean deletePVC) {
        StatefulSetList statefulSetList = (StatefulSetList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list();
        this.forceDeleteStatefulsets(statefulSetList.getItems(), namespace, deletePVC);
    }

    public void forceDeleteOrphanedStatefulsets(Collection<String> deployedStatefulsets, String namespace, String releaseName) {
        StatefulSetList statefulSetList = (StatefulSetList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().statefulSets().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list();
        List<StatefulSet> orphanedStatefulsets = statefulSetList.getItems().stream().filter(sts -> !deployedStatefulsets.contains(sts.getMetadata().getName())).collect(Collectors.toList());
        this.forceDeleteStatefulsets(orphanedStatefulsets, namespace, true);
    }

    public void deleteDataPodsForRelease(String namespace, String releaseName) {
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabelSelector(String.format("app.kubernetes.io/instance=%s,app.kubernetes.io/name=imply-data", releaseName))).delete();
    }

    public boolean isPodTerminatingInNamespace(String namespace, String podId) {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podId)).get();
        if (pod == null) {
            return false;
        }
        return pod.getMetadata().getDeletionTimestamp() != null;
    }

    public void evictPodForNamespace(String namespace, String podId) {
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podId)).evict();
    }

    public void deletePodForNamespace(String namespace, String podId) {
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podId)).delete();
    }

    private List<PersistentVolumeClaim> getUnusedPVCsForRelease(String namespace, String releaseName) {
        List pvcList = ((PersistentVolumeClaimList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.persistentVolumeClaims().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list()).getItems();
        if (CollectionUtils.isEmpty((Collection)pvcList)) {
            return pvcList;
        }
        PodList podList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabelSelector(String.format(RELEASE_SELECTOR, releaseName))).list();
        return pvcList.stream().filter(pvc -> {
            String pvcName = pvc.getMetadata().getName();
            Stream<Pod> mountPods = podList.getItems().stream().filter(pod -> {
                Stream<Volume> pvcVolumes = pod.getSpec().getVolumes().stream().filter(v -> v.getPersistentVolumeClaim() != null);
                return pvcVolumes.anyMatch(v -> v.getPersistentVolumeClaim().getClaimName().equals(pvcName));
            });
            return !mountPods.findAny().isPresent();
        }).collect(Collectors.toList());
    }

    private void deletePVCs(List<PersistentVolumeClaim> pvcList) {
        pvcList.stream().forEach(pvc -> {
            try {
                List deleted = ((Resource)((NonNamespaceOperation)this.client.persistentVolumeClaims().inNamespace(pvc.getMetadata().getNamespace())).withName(pvc.getMetadata().getName())).delete();
                if (deleted.isEmpty()) {
                    log.warn("Unable to delete PVC [%s] in namespace [%s]", new Object[]{pvc.getMetadata().getName(), pvc.getMetadata().getNamespace()});
                }
            }
            catch (KubernetesClientException e) {
                log.warn((Throwable)e, "Unable to delete PVC [%s] in namespace [%s]", new Object[]{pvc.getMetadata().getName(), pvc.getMetadata().getNamespace()});
            }
        });
    }

    public void deleteUnusedPVCsForRelease(String namespace, String releaseName) {
        List<PersistentVolumeClaim> pvcList = this.getUnusedPVCsForRelease(namespace, releaseName);
        log.debug("Found [%d] unused PVCs in namespace [%s]", new Object[]{pvcList.size(), namespace});
        this.deletePVCs(pvcList);
    }

    public void deleteNonPendingUnusedPVCsForRelease(String namespace, String releaseName) {
        List<Object> pvcList = this.getUnusedPVCsForRelease(namespace, releaseName);
        pvcList = pvcList.stream().filter(pvc -> Optional.ofNullable(pvc.getStatus()).map(PersistentVolumeClaimStatus::getPhase).map(p -> !p.equalsIgnoreCase("pending")).orElse(false)).collect(Collectors.toList());
        log.debug("Found [%d] unused and non pending PVCs in namespace [%s]", new Object[]{pvcList.size(), namespace});
        this.deletePVCs(pvcList);
    }

    public void removeIngestConfigs(String namespace, String releaseName) {
        List configMaps = ((ConfigMapList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).withLabel("app.kubernetes.io/instance", releaseName)).withLabel("imply.io/worker_version")).list()).getItems();
        this.deleteIngestConfigMaps(configMaps, namespace, true);
    }

    public void cleanupUnusedIngestConfigs(String namespace, String releaseName, String currentWorkerVersion) {
        List configMaps = ((ConfigMapList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).withLabel("app.kubernetes.io/instance", releaseName)).withLabel("imply.io/worker_version")).withLabelNotIn("imply.io/worker_version", new String[]{currentWorkerVersion})).list()).getItems();
        this.deleteIngestConfigMaps(configMaps, namespace, false);
    }

    private void deleteIngestConfigMaps(List<ConfigMap> configMaps, String namespace, boolean skipPendingPodsCheck) {
        configMaps.stream().filter(cm -> skipPendingPodsCheck || ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabel("imply.io/worker_version", (String)cm.getMetadata().getLabels().get("imply.io/worker_version"))).list()).getItems().stream().count() == 0L).forEach(cm -> this.client.resource((HasMetadata)cm).delete());
    }

    public void maybeCleanupRunningDruidJobs(String namespace) {
        try {
            ((FilterWatchListDeletable)((NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace)).withLabel(DRUID_PEON_JOB_LABEL, "true")).delete();
        }
        catch (Exception e) {
            log.warn("Failed to delete running peon jobs for namespace [%s], message: '%s'", new Object[]{namespace, e.getMessage()});
        }
    }

    public PodList getRunningDruidJobPods(String namespace, String workerVersion) {
        return (PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabel(DRUID_PEON_JOB_LABEL, "true")).withLabelNotIn("imply.io/worker_version", new String[]{workerVersion})).withLabelNotIn(DRUID_TASK_TYPE_LABEL, EXCLUDED_TASK_TYPES)).list();
    }

    @Inject
    @Generated
    public KubernetesUtils(KubernetesClient client) {
        this.client = client;
    }
}

