/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.joda.time.Period;

public class ExecUtils {
    public static ExecResult execute(String command, Period timeout, File file, String ... args) throws IOException, TimeoutException {
        Preconditions.checkNotNull((Object)command, (Object)"A command must be specified");
        ImmutableList c = ImmutableList.builder().add((Object)command).add((Object[])args).build();
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)c).redirectErrorStream(true).directory(Files.createTempDirectory("exec-", new FileAttribute[0]).toFile());
        if (file != null) {
            processBuilder.redirectOutput(file);
        }
        Process process = processBuilder.start();
        int exitValue = 1;
        try {
            if (!process.waitFor(timeout.toStandardDuration().getMillis(), TimeUnit.MILLISECONDS)) {
                process.destroy();
                throw new TimeoutException();
            }
            exitValue = process.exitValue();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return new ExecResult(exitValue, IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8));
    }

    public static ExecResult execute(String command, Period timeout, List<String> args) throws IOException, TimeoutException {
        return ExecUtils.execute(command, timeout, null, args.toArray(new String[0]));
    }

    public static ExecResult execute(String command, Period timeout, File file, List<String> args) throws IOException, TimeoutException {
        return ExecUtils.execute(command, timeout, file, args.toArray(new String[0]));
    }

    @Generated
    private ExecUtils() {
    }

    public static class ExecResult {
        private final int exitValue;
        private final String output;

        @Generated
        public int getExitValue() {
            return this.exitValue;
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public ExecResult(int exitValue, String output) {
            this.exitValue = exitValue;
            this.output = output;
        }
    }
}

