/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage.creation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.exception.GroveAgentException;
import io.imply.cloud.grove.GroveResult;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremWriteConfigServerRequestPayloadStage
extends BaseStage
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremWriteConfigServerRequestPayloadStage.class);
    private final Set<ImplyNodeType> nodeTypes;
    private final String groveServer;
    private final String host;
    private final String configServerKey;

    @JsonCreator
    public OnPremWriteConfigServerRequestPayloadStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeTypes") Set<ImplyNodeType> nodeTypes, @JsonProperty(value="groveServer") String groveServer, @JsonProperty(value="host") String host, @JsonProperty(value="configServerKey") String configServerKey) {
        super(toolbox, clusterId);
        this.nodeTypes = nodeTypes;
        this.groveServer = groveServer;
        this.host = host;
        this.configServerKey = configServerKey;
    }

    public boolean innerRun() throws JsonProcessingException {
        List results;
        if (!this.toolbox.getClusterNodesHelper().isHostOnline(this.getClusterId(), this.host).booleanValue()) {
            log.info("Host [%s] no longer exists, skipping stage", new Object[]{this.host});
            return true;
        }
        int tier = this.nodeTypes.stream().map(ImplyNodeType::getTierNumber).max(Integer::compare).orElse(0);
        if (tier != this.nodeTypes.stream().map(ImplyNodeType::getTierNumber).mapToInt(Integer::intValue).sum()) {
            throw new ISE("A host cannot be part of more than one data tier", new Object[0]);
        }
        String instanceType = null;
        if (this.toolbox.getApplicationConfig().isKubernetesMode()) {
            Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
            if (this.nodeTypes.contains(ImplyNodeType.MASTER)) {
                instanceType = cluster.getMasterInstanceType();
            } else if (this.nodeTypes.contains(ImplyNodeType.QUERY)) {
                instanceType = cluster.getQueryInstanceType();
            } else if (this.nodeTypes.contains(ImplyNodeType.DATA_TIER_1)) {
                instanceType = ((InstanceTier)cluster.getDataInstanceTiers().get(1)).getInstanceType();
            } else if (this.nodeTypes.contains(ImplyNodeType.DATA_TIER_2)) {
                instanceType = ((InstanceTier)cluster.getDataInstanceTiers().get(2)).getInstanceType();
            } else if (this.nodeTypes.contains(ImplyNodeType.DATA_TIER_3)) {
                instanceType = ((InstanceTier)cluster.getDataInstanceTiers().get(3)).getInstanceType();
            } else {
                Optional<ImplyNodeType> dataNodeType = this.nodeTypes.stream().filter(nodeType -> nodeType.getServiceType().equals(ImplyNodeType.DATA.getServiceType())).findFirst();
                if (dataNodeType.isPresent()) {
                    instanceType = ((InstanceTier)cluster.getDataInstanceTiers().get(dataNodeType.get().getTierNumber())).getInstanceType();
                }
            }
        }
        instanceType = instanceType == null ? "onprem" : instanceType;
        List groveNodes = this.toolbox.getGroveClient().getGroveNodes(this.groveServer, true);
        String hostname = groveNodes.stream().filter(x -> this.host.equals(x.getAddress())).map(Node::getHostname).findFirst().orElse(null);
        if (hostname == null) {
            log.info("Waiting for host [%s] to come online", new Object[]{this.host});
            return false;
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        contents.put("clusterId", this.getClusterId());
        contents.put("instanceType", instanceType);
        contents.put("instanceTier", tier);
        contents.put("instanceId", hostname);
        contents.put("serviceTypes", this.nodeTypes.stream().map(ImplyNodeType::getServiceType).collect(Collectors.toSet()));
        contents.put("key", this.configServerKey);
        contents.put("privateIpAddresses", ImmutableList.of((Object)this.host));
        contents.put("publicIpAddresses", ImmutableList.of((Object)"@{IMPLY_AGENT_IP_ADDRESS}"));
        contents.put("privateHostnames", ImmutableList.of((Object)hostname));
        contents.put("publicHostnames", ImmutableList.of((Object)"@{IMPLY_AGENT_FQDN}"));
        if (this.nodeTypes.contains(ImplyNodeType.INGEST)) {
            contents.put("configVersion", "@{IMPLY_CONFIG_VERSION}");
            contents.put("instanceType", this.getWorkerIngestInstanceType());
        }
        if ((results = this.toolbox.getGroveClient().write(this.groveServer, (List)ImmutableList.of((Object)this.host), this.toolbox.getObjectMapper().writeValueAsString(contents), "/opt/imply/onprem/conf/config-server.json", Integer.valueOf(644))) == null || results.isEmpty()) {
            throw new ISE("Empty response returned from Grove server", new Object[0]);
        }
        if (!((GroveResult)results.get(0)).isOk()) {
            throw new GroveAgentException("Server returned failure response for [%s]: %s", new Object[]{this.host, ((GroveResult)results.get(0)).getErrorMessage()});
        }
        return true;
    }

    @JsonProperty
    public Set<ImplyNodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    @JsonProperty
    public String getGroveServer() {
        return this.groveServer;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public String getConfigServerKey() {
        return this.configServerKey;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 30;
    }

    protected String getWorkerIngestInstanceType() {
        return "ingest";
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Writing config server request payload to [%s]", this.host);
    }
}

