/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage.creation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.exception.GroveAgentException;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.Logger;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremStopServicesStage
extends BaseStage
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremStopServicesStage.class);
    private final String groveServer;
    private final List<String> hosts;

    @JsonCreator
    public OnPremStopServicesStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="groveServer") String groveServer, @JsonProperty(value="hosts") List<String> hosts) {
        super(toolbox, clusterId);
        this.groveServer = groveServer;
        this.hosts = hosts;
    }

    public boolean innerRun() {
        try {
            this.toolbox.getGroveClient().simpleRun(this.groveServer, this.hosts, "grove-stop", 90, true);
        }
        catch (GroveAgentException e) {
            log.info("Failed to stop services on hosts %s; continuing to next stage: %s", new Object[]{this.hosts, e.getMessage()});
        }
        return true;
    }

    @JsonProperty
    public String getGroveServer() {
        return this.groveServer;
    }

    @JsonProperty
    public List<String> getHosts() {
        return this.hosts;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 10;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Stopping services on hosts %s", this.hosts);
    }
}

