/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage.creation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.imply.cloud.exception.StagedOperationException;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.JdbcURIParser;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.metadatastorage.MySqlMetadataStorage;
import io.imply.cloud.model.metadatastorage.PostgreSqlMetadataStorage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.persistence.mysql.MySQLStorageConnector;
import io.imply.cloud.persistence.postgresql.PostgreSQLStorageConnector;
import io.imply.cloud.tls.TLSUtils;
import io.imply.cloud.util.PropertiesHelper;
import io.imply.cloud.util.StringUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremMaybeCreateMetadataDatabaseStage
extends BaseStage
implements OnPremHelpers {
    @JsonCreator
    public OnPremMaybeCreateMetadataDatabaseStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId) {
        super(toolbox, clusterId);
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        if (cluster.getMetadataStorage() instanceof MySqlMetadataStorage) {
            OnPremMaybeCreateMetadataDatabaseStage.maybeCreateMySqlDatabase(cluster);
        } else if (cluster.getMetadataStorage() instanceof PostgreSqlMetadataStorage) {
            OnPremMaybeCreateMetadataDatabaseStage.maybeCreatePostgreSqlDatabase(cluster);
        }
        return true;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 5;
    }

    public Integer getMaxConsecutiveExceptions() {
        return 3;
    }

    @JsonProperty
    public String getDescription() {
        return "Checking metadata storage exists and is reachable";
    }

    private static JdbcURIParser maybeGetConnectUriFromOverride(Cluster cluster) {
        if (cluster == null || cluster.getCustomDruidProperties() == null) {
            return null;
        }
        Map commonProps = PropertiesHelper.convertPropertiesFileToMap((String)((String)cluster.getCustomDruidProperties().get(ServiceType.COMMON.getCustomDruidPropertiesKey())));
        String connectURI = (String)commonProps.get("druid.metadata.storage.connector.connectURI");
        if (connectURI == null) {
            return null;
        }
        try {
            return JdbcURIParser.parse((String)connectURI);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static void maybeCreateMySqlDatabase(Cluster cluster) {
        JdbcURIParser jdbcURI;
        String connectionParams;
        MySqlMetadataStorage metaStore = (MySqlMetadataStorage)cluster.getMetadataStorage();
        Path tempCertPath = null;
        Path tempClientPath = null;
        if (!Strings.isNullOrEmpty((String)metaStore.getTlsCert())) {
            try {
                tempCertPath = Files.createTempFile(null, null, new FileAttribute[0]);
                byte[] truststore = TLSUtils.generateClientTruststore((String)cluster.getMetadataStorage().getTlsCert(), (String)"metadata-store-ca-", (String)"implymanager");
                Files.write(tempCertPath, truststore, new OpenOption[0]);
            }
            catch (Exception e) {
                if (tempCertPath != null) {
                    FileUtils.deleteQuietly((File)tempCertPath.toFile());
                }
                throw new RuntimeException("Failed to create temporary truststore for metadata store certificate", e);
            }
            if (!Strings.isNullOrEmpty((String)metaStore.getClientCert()) && !Strings.isNullOrEmpty((String)metaStore.getClientKey())) {
                try {
                    tempClientPath = Files.createTempFile(null, null, new FileAttribute[0]);
                    byte[] keystore = TLSUtils.generateClientKeystore((String)metaStore.getClientCert(), (String)metaStore.getClientKey(), (String)"metadata-store-client-", (String)"implymanager");
                    Files.write(tempClientPath, keystore, new OpenOption[0]);
                }
                catch (Exception e) {
                    if (tempClientPath != null) {
                        FileUtils.deleteQuietly((File)tempClientPath.toFile());
                    }
                    throw new RuntimeException("Failed to create temporary keystore for metadata store client certificate and key", e);
                }
            }
        }
        String string = connectionParams = (jdbcURI = OnPremMaybeCreateMetadataDatabaseStage.maybeGetConnectUriFromOverride(cluster)) != null ? jdbcURI.getQuery() : metaStore.getConnectionParameters();
        if (tempCertPath != null) {
            String tlsParams = String.format("trustCertificateKeyStoreUrl=file://%s&trustCertificateKeyStorePassword=%s", tempCertPath, "implymanager");
            String string2 = connectionParams = connectionParams == null ? tlsParams : connectionParams.concat("&" + tlsParams);
        }
        if (tempClientPath != null) {
            String clientCertParams = String.format("clientCertificateKeyStoreUrl=file://%s&clientCertificateKeyStorePassword=%s", tempClientPath, "implymanager");
            connectionParams = connectionParams == null ? clientCertParams : connectionParams.concat("&" + clientCertParams);
        }
        try {
            MySQLStorageConnector.createDatabaseIfNotExists((String)(jdbcURI != null ? jdbcURI.getProtocol() : ""), (String)(jdbcURI != null ? jdbcURI.getHost() : metaStore.getHost()), (int)(jdbcURI != null ? jdbcURI.getPort() : (metaStore.getPort() != null ? metaStore.getPort() : 3306)), (String)(jdbcURI != null ? StringUtils.stripLeadingAndTrailingChars((char)'/', (String)jdbcURI.getPath()) : metaStore.getSchema()), (String)metaStore.getUser(), (String)metaStore.getPassword(), (String)connectionParams);
        }
        catch (Exception e) {
            throw new StagedOperationException(String.format("MySQL: %s", ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        finally {
            if (tempCertPath != null) {
                FileUtils.deleteQuietly((File)tempCertPath.toFile());
            }
        }
    }

    private static void maybeCreatePostgreSqlDatabase(Cluster cluster) {
        JdbcURIParser jdbcURI;
        String connectionParams;
        PostgreSqlMetadataStorage metaStore = (PostgreSqlMetadataStorage)cluster.getMetadataStorage();
        Path tempCertPath = null;
        Path tempClientCertPath = null;
        Path tempClientKeyPath = null;
        if (!Strings.isNullOrEmpty((String)metaStore.getTlsCert())) {
            try {
                tempCertPath = Files.createTempFile(null, null, new FileAttribute[0]);
                Files.write(tempCertPath, metaStore.getTlsCert().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (Exception e) {
                if (tempCertPath != null) {
                    FileUtils.deleteQuietly((File)tempCertPath.toFile());
                }
                throw new RuntimeException("Failed to create temporary metadata store certificate", e);
            }
            if (!Strings.isNullOrEmpty((String)metaStore.getClientCert()) && !Strings.isNullOrEmpty((String)metaStore.getClientKey())) {
                try {
                    tempClientCertPath = Files.createTempFile(null, null, new FileAttribute[0]);
                    tempClientKeyPath = Files.createTempFile(null, ".pk8", new FileAttribute[0]);
                    Files.write(tempClientCertPath, metaStore.getClientCert().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    byte[] clientKeyPk8 = TLSUtils.generateClientDERFromPEM((String)cluster.getMetadataStorage().getClientKey());
                    Files.write(tempClientKeyPath, clientKeyPk8, new OpenOption[0]);
                }
                catch (Exception e) {
                    if (tempClientCertPath != null) {
                        FileUtils.deleteQuietly((File)tempClientCertPath.toFile());
                    }
                    if (tempClientKeyPath != null) {
                        FileUtils.deleteQuietly((File)tempClientKeyPath.toFile());
                    }
                    throw new RuntimeException("Failed to create temporary metadata store client certificate and key", e);
                }
            }
        }
        String string = connectionParams = (jdbcURI = OnPremMaybeCreateMetadataDatabaseStage.maybeGetConnectUriFromOverride(cluster)) != null ? jdbcURI.getQuery() : metaStore.getConnectionParameters();
        if (tempCertPath != null) {
            String tlsParams = String.format("sslrootcert=%s", tempCertPath);
            String string2 = connectionParams = connectionParams == null ? tlsParams : connectionParams.concat("&" + tlsParams);
        }
        if (tempClientCertPath != null && tempClientKeyPath != null) {
            String clientTlsParams = String.format("sslcert=%s&sslkey=%s", tempClientCertPath, tempClientKeyPath);
            connectionParams = connectionParams == null ? clientTlsParams : connectionParams.concat("&" + clientTlsParams);
        }
        try {
            PostgreSQLStorageConnector.createDatabaseIfNotExists((String)(jdbcURI != null ? jdbcURI.getHost() : metaStore.getHost()), (int)(jdbcURI != null ? jdbcURI.getPort() : (metaStore.getPort() != null ? metaStore.getPort() : 5432)), (String)(jdbcURI != null ? StringUtils.stripLeadingAndTrailingChars((char)'/', (String)jdbcURI.getPath()) : metaStore.getSchema()), (String)metaStore.getUser(), (String)metaStore.getPassword(), (String)connectionParams);
        }
        catch (Exception e) {
            throw new StagedOperationException(String.format("PostgreSQL: %s", ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        finally {
            if (tempCertPath != null) {
                FileUtils.deleteQuietly((File)tempCertPath.toFile());
            }
        }
    }
}

