/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage.creation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.Toolbox;
import io.imply.cloud.grove.GroveAgentUtil;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.server.jetty.ServerConfig;
import io.imply.cloud.util.Logger;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremFetchConfigBundleStage
extends BaseStage
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremFetchConfigBundleStage.class);
    private final String groveServer;
    private final List<String> hosts;
    private final OnPremManagerToolbox onPremManagerToolbox;

    @JsonCreator
    public OnPremFetchConfigBundleStage(@JacksonInject OnPremManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="groveServer") String groveServer, @JsonProperty(value="hosts") List<String> hosts) {
        super((ManagerToolbox)toolbox, clusterId);
        this.groveServer = groveServer;
        this.hosts = hosts;
        this.onPremManagerToolbox = toolbox;
    }

    public boolean innerRun() {
        List onlineHosts = this.toolbox.getClusterNodesHelper().filterOnlineHosts(this.getClusterId(), this.hosts);
        if (onlineHosts.isEmpty()) {
            log.info("No hosts from [%s] are online, skipping stage", new Object[]{String.join((CharSequence)",", this.hosts)});
            return true;
        }
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        String contents = GroveAgentUtil.getCurlRunStringForConfigFile((String)"/opt/imply/conf/conf.zip", (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/config/v1", "config-bundle"), (Toolbox)this.toolbox) + " && (cd /opt/imply/conf && unzip -o conf.zip && rm conf.zip) && chmod +x /opt/imply/conf/bin/*";
        this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, contents, 30, true);
        this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, GroveAgentUtil.getCurlRunStringForConfigFile((String)String.format("%s/%s", this.onPremManagerToolbox.getOnPremManagerConfig().getAgentEtcDirectory(), "grove-init.yaml"), (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/config/v1", "grove-init"), (Toolbox)this.toolbox), 30, true);
        this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, GroveAgentUtil.getCurlRunStringForConfigFile((String)String.format("%s/%s", this.onPremManagerToolbox.getOnPremManagerConfig().getAgentEtcDirectory(), "logview.yaml"), (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/config/v1", "logview"), (Toolbox)this.toolbox), 30, true);
        this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, GroveAgentUtil.getCurlRunStringForConfigFile((String)"/opt/imply/conf/userFilePaths", (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/config/v1", "user-files-x"), (Toolbox)this.toolbox), 30, true);
        if (cluster.isUseTls() != null && cluster.isUseTls().booleanValue()) {
            this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, GroveAgentUtil.getCurlRunStringForConfigFile((String)"/opt/imply/conf/druid/_common/keystore.jks", (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/auth/v1", "keystore"), (Toolbox)this.toolbox), 30, true);
            this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, GroveAgentUtil.getCurlRunStringForConfigFile((String)"/opt/imply/conf/druid/_common/truststore.jks", (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/auth/v1", "truststore"), (Toolbox)this.toolbox), 30, true);
        }
        this.chownConfigs(onlineHosts);
        return true;
    }

    @JsonProperty
    public String getGroveServer() {
        return this.groveServer;
    }

    @JsonProperty
    public List<String> getHosts() {
        return this.hosts;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 10;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Fetching configuration bundle from config server for hosts %s", this.hosts);
    }

    protected String getManagerHostAndPortOrPlaceholder() {
        return this.onPremManagerToolbox.getOnPremManagerConfig().isUseManagerHostPlaceholder() ? String.format("%s:%s", "@{IMPLY_MANAGER_HOST}", "@{IMPLY_MANAGER_BE_PORT}") : this.toolbox.getApplicationNode().getHostAndPort();
    }

    protected String getUsernameAndPasswordOrPlaceholder() {
        ServerConfig serverConfig = this.toolbox.getServerConfig();
        if (serverConfig.getUsername() != null && serverConfig.getPassword() != null) {
            String token = this.onPremManagerToolbox.getOnPremManagerConfig().isUseManagerHostPlaceholder() ? "@{IMPLY_MANAGER_AUTH_TOKEN}" : serverConfig.getPassword();
            return String.format("%s:%s", serverConfig.getUsername(), token);
        }
        return null;
    }

    protected void chownConfigs(List<String> onlineHosts) {
        String serviceUser = this.onPremManagerToolbox.getOnPremManagerConfig().getGroveServiceUser();
        String serviceGroup = this.onPremManagerToolbox.getOnPremManagerConfig().getGroveServiceGroup();
        this.toolbox.getGroveClient().simpleRun(this.groveServer, onlineHosts, String.format("chown -R %s:%s /opt/imply/conf", serviceUser, serviceGroup), 30, true);
    }
}

