/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage.creation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremBecomeServicesStage
extends BaseStage
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremBecomeServicesStage.class);
    private final String groveServer;
    private final List<String> hosts;
    private final OnPremManagerToolbox onPremManagerToolbox;

    @JsonCreator
    public OnPremBecomeServicesStage(@JacksonInject OnPremManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="groveServer") String groveServer, @JsonProperty(value="hosts") List<String> hosts) {
        super((ManagerToolbox)toolbox, clusterId);
        this.groveServer = groveServer;
        this.hosts = hosts;
        this.onPremManagerToolbox = toolbox;
    }

    public boolean innerRun() {
        List onlineHosts = this.toolbox.getClusterNodesHelper().filterOnlineHosts(this.getClusterId(), this.hosts);
        if (onlineHosts.isEmpty()) {
            log.info("No hosts from [%s] are online, skipping stage", new Object[]{String.join((CharSequence)",", this.hosts)});
            return true;
        }
        ImmutableList postDeployParams = ImmutableList.of((Object)"/opt/imply/conf/bin/fetch-additional-files", (Object)"/opt/imply/conf/bin/post-init-actions-onprem");
        this.toolbox.getGroveClient().becomeWithServiceYamlPath(this.groveServer, onlineHosts, String.format("%s/%s", this.onPremManagerToolbox.getOnPremManagerConfig().getAgentEtcDirectory(), "grove-init.yaml"), "imply", (List)postDeployParams, true);
        return true;
    }

    @JsonProperty
    public String getGroveServer() {
        return this.groveServer;
    }

    @JsonProperty
    public List<String> getHosts() {
        return this.hosts;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 240;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Starting up services on hosts %s", this.hosts);
    }
}

