/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremUpdateMasterWorkerVersionLabelStage
extends BaseStage {
    private final K8sUtilsProvider k8sUtilsProvider;
    private final String workerVersion;

    @JsonCreator
    public OnPremUpdateMasterWorkerVersionLabelStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="workerVersion") String workerVersion) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.workerVersion = workerVersion;
    }

    public boolean innerRun() throws Exception {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(cluster);
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.toolbox.getApplicationConfig());
        FilterWatchListDeletable workerLabelDeployments = (FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withLabel("imply.io/imply_node_type", ImplyNodeType.MASTER.camelCasedName())).withLabel("app.kubernetes.io/instance", releaseName);
        if (FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.IMMUTABLE_CONTAINERS, (RefreshableConstants)this.toolbox.getRefreshableConstants()) && FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.SINGLE_SERVICE_MASTER_PODS, (RefreshableConstants)this.toolbox.getRefreshableConstants())) {
            workerLabelDeployments = (FilterWatchListDeletable)workerLabelDeployments.withLabel("imply.io/imply_service_type", ServiceType.OVERLORD.getName());
        }
        ((DeploymentList)workerLabelDeployments.list()).getItems().stream().forEach(deployment -> ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(deployment.getMetadata().getName())).edit(d -> ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder(d).editMetadata().addToLabels("imply.io/worker_version", this.workerVersion)).endMetadata()).editSpec().editTemplate().editMetadata().addToLabels("imply.io/worker_version", this.workerVersion)).endMetadata()).endTemplate()).endSpec()).build()));
        return true;
    }

    @JsonProperty
    public String getWorkerVersion() {
        return this.workerVersion;
    }

    @JsonProperty
    public String getDescription() {
        return "Updating worker version";
    }
}

