/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.util.Logger;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremKubernetesEvictPodStage
extends BaseStage {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesEvictPodStage.class);
    private final String podId;
    private final Boolean forceDeletion;
    private final K8sUtilsProvider k8sUtilsProvider;

    @JsonCreator
    public OnPremKubernetesEvictPodStage(@JacksonInject ManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="podId") String podId, @JsonProperty(value="forceDeletion") Boolean forceDeletion) {
        super(toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.podId = podId;
        this.forceDeletion = forceDeletion;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        ApplicationConfig applicationConfig = this.toolbox.getApplicationConfig();
        String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, applicationConfig);
        try {
            if (this.getForceDeletion().booleanValue()) {
                this.k8sUtilsProvider.getKubernetesUtils(cluster).deletePodForNamespace(clusterNamespace, this.podId);
                return true;
            }
            this.k8sUtilsProvider.getKubernetesUtils(cluster).evictPodForNamespace(clusterNamespace, this.podId);
        }
        catch (KubernetesClientException e) {
            log.warn((Throwable)e, "Unable to evict pod [%s] in cluster [%s], operation will be retried", new Object[]{this.podId, this.getClusterId()});
            return false;
        }
        return true;
    }

    @JsonProperty
    public String getPodId() {
        return this.podId;
    }

    @JsonProperty
    public Boolean getForceDeletion() {
        return BooleanUtils.isTrue((Boolean)this.forceDeletion);
    }

    @JsonProperty
    public String getDescription() {
        if (this.getForceDeletion().booleanValue()) {
            return String.format("Deleting pod %s", this.podId);
        }
        return String.format("Evicting pod %s", this.podId);
    }
}

