/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.KubernetesManifestUtils;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import java.util.ArrayList;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremDeleteKubernetesManifestsStage
extends BaseStage {
    @Generated
    private static final Logger log = Logger.from(OnPremDeleteKubernetesManifestsStage.class);
    private final K8sUtilsProvider k8sUtilsProvider;
    private final KubernetesManifestUtils kubernetesManifestUtils;
    private final boolean isTerminalState;

    @JsonCreator
    public OnPremDeleteKubernetesManifestsStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JacksonInject KubernetesManifestUtils kubernetesManifestUtils, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="isTerminalState") boolean isTerminalState) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.kubernetesManifestUtils = kubernetesManifestUtils;
        this.isTerminalState = isTerminalState;
    }

    public boolean innerRun() {
        Pair<Cluster, Cluster> clusterPair = this.getClusterPair();
        Cluster currentCluster = (Cluster)clusterPair.lhs;
        Cluster desiredCluster = (Cluster)clusterPair.rhs;
        Account account = this.toolbox.getAccountDataManager().get(desiredCluster.getAccountId());
        String namespace = HelmUtils.generateNamespaceForCluster(desiredCluster, this.toolbox.getApplicationConfig());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(desiredCluster);
        Secret deploymentSecret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(this.kubernetesManifestUtils.generateDataPlaneReleaseSecretName(currentCluster))).get();
        if (deploymentSecret == null) {
            log.warn("Could not find deployment secret for cluster version [%d], skipping deletion.", new Object[]{currentCluster.getVersion()});
            return true;
        }
        ArrayList<HasMetadata> manifests = new ArrayList<HasMetadata>(this.kubernetesManifestUtils.generateRemovedManifests(deploymentSecret, desiredCluster, account, this.getIsTerminalState()));
        manifests.add((HasMetadata)deploymentSecret);
        ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList(manifests).inNamespace(namespace)).delete();
        return true;
    }

    private Pair<Cluster, Cluster> getClusterPair() {
        Info info = this.getInfo();
        Cluster proposed = this.toolbox.getClusterDataManager().getVersionOrNull(this.getClusterId(), info.getProposedClusterVersion().intValue());
        Cluster deployed = this.toolbox.getClusterDataManager().getVersionOrNull(this.getClusterId(), info.getDeployedClusterVersion().intValue());
        return info.getDesiredState().equals((Object)State.CLUSTER_UPDATE_ROLLED_BACK) ? Pair.of((Object)proposed, (Object)deployed) : Pair.of((Object)deployed, (Object)proposed);
    }

    @JsonProperty
    public String getDescription() {
        return this.isTerminalState ? "Deleting all manifests" : "Deleting removed manifests";
    }

    @JsonProperty
    public boolean getIsTerminalState() {
        return this.isTerminalState;
    }
}

