/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremCleanupDataTiersStage
extends BaseStage {
    @Generated
    private static final Logger log = Logger.from(OnPremCleanupDataTiersStage.class);
    private final K8sUtilsProvider k8sUtilsProvider;

    @JsonCreator
    public OnPremCleanupDataTiersStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(cluster);
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String[] desiredStatefulsetNames = (String[])this.toolbox.getClusterUpdateHelper().getRunningTiers(cluster).stream().map(ImplyNodeType::camelCasedName).sorted().toArray(String[]::new);
        List removedStatefulsets = ((StatefulSetList)((FilterWatchListDeletable)((NonNamespaceOperation)client.apps().statefulSets().inNamespace(namespace)).withLabelNotIn("imply.io/imply_node_type", desiredStatefulsetNames)).list()).getItems();
        if (removedStatefulsets.isEmpty()) {
            log.info("No orphaned statefulsets found to remove.");
            return true;
        }
        log.info("Removing orphaned statefulsets: [%s]", new Object[]{removedStatefulsets.stream().map(statefulSet -> statefulSet.getMetadata().getName()).collect(Collectors.joining(", "))});
        ((FilterWatchListDeletable)((NonNamespaceOperation)client.apps().statefulSets().inNamespace(namespace)).withLabelNotIn("imply.io/imply_node_type", desiredStatefulsetNames)).delete();
        return true;
    }

    @JsonProperty
    public String getDescription() {
        return "Removing any orphaned data tier statefulsets";
    }
}

