/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.AwaitQueryInstancesAvailableStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitQueryInstancesAvailableStage
extends AwaitQueryInstancesAvailableStage
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremAwaitQueryInstancesAvailableStage.class);
    private final Integer numInstances;

    @JsonCreator
    public OnPremAwaitQueryInstancesAvailableStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="numInstances") Integer numInstances) {
        super(toolbox, clusterId, ImplyNodeType.QUERY);
        this.numInstances = numInstances;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().getOrNull(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get(cluster != null ? cluster.getAccountId() : "onprem");
        List<Node> groveNodes = this.toolbox.getGroveClient().getGroveNodes(account.getGroveServer(), true).stream().filter(Node::isImplyRunning).filter(x -> cluster.getClusterId().equals(x.getActiveClusterId())).filter(x -> x.getImplyNodeTypes().stream().anyMatch(arg_0 -> ((ImplyNodeType)ImplyNodeType.QUERY).equals(arg_0))).collect(Collectors.toList());
        if (this.toolbox.getApplicationConfig().isSaaS() || this.toolbox.getApplicationConfig().isIOW()) {
            return this.isBrokerReadyWithoutPivot(groveNodes);
        }
        return this.isBrokerReadyWithPivot(groveNodes);
    }

    private boolean isBrokerReadyWithoutPivot(List<Node> groveNodes) {
        int brokerOKCount = 0;
        int routerOKCount = 0;
        HashSet<String> unresponsiveNodes = new HashSet<String>();
        for (Node node : groveNodes) {
            if (this.toolbox.getDruidApiClient().isBrokerStatusOK(node.getAddress(), this.getClusterId())) {
                ++brokerOKCount;
            } else {
                unresponsiveNodes.add(node.getAddress());
            }
            if (this.toolbox.getDruidApiClient().isRouterStatusOK(node.getAddress(), this.getClusterId())) {
                ++routerOKCount;
                continue;
            }
            unresponsiveNodes.add(node.getAddress());
        }
        log.info("Waiting for at least [%d] query nodes available; found [%d] broker / [%d] router (awaiting: %s)", new Object[]{this.numInstances, brokerOKCount, routerOKCount, unresponsiveNodes});
        return brokerOKCount >= this.numInstances && routerOKCount >= this.numInstances;
    }

    private boolean isBrokerReadyWithPivot(List<Node> groveNodes) {
        int brokerOKCount = 0;
        int routerOKCount = 0;
        int pivotOKCount = 0;
        HashSet<String> unresponsiveNodes = new HashSet<String>();
        for (Node node : groveNodes) {
            if (this.toolbox.getDruidApiClient().isBrokerStatusOK(node.getAddress(), this.getClusterId())) {
                ++brokerOKCount;
            } else {
                unresponsiveNodes.add(node.getAddress());
            }
            if (this.toolbox.getDruidApiClient().isRouterStatusOK(node.getAddress(), this.getClusterId())) {
                ++routerOKCount;
            } else {
                unresponsiveNodes.add(node.getAddress());
            }
            if (this.toolbox.getDruidApiClient().isPivotHealthOK(node.getAddress(), this.getClusterId(), node.getManagerClusterVersion())) {
                ++pivotOKCount;
                continue;
            }
            unresponsiveNodes.add(node.getAddress());
        }
        log.info("Waiting for at least [%d] query nodes available; found [%d] broker / [%d] router / [%d] Pivot nodes (awaiting: %s)", new Object[]{this.numInstances, brokerOKCount, routerOKCount, pivotOKCount, unresponsiveNodes});
        return brokerOKCount >= this.numInstances && routerOKCount >= this.numInstances && pivotOKCount >= this.numInstances;
    }

    @JsonProperty
    public Integer getNumInstances() {
        return this.numInstances;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 30;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for [%d] query node%s to be available", this.numInstances, this.numInstances == 1 ? "" : "s");
    }
}

