/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Notification;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitPodsDeletedStage
extends BaseStage {
    private final K8sUtilsProvider k8sUtilsProvider;
    private final ImplyNodeType implyNodeType;

    @JsonCreator
    public OnPremAwaitPodsDeletedStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.implyNodeType = implyNodeType;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.toolbox.getApplicationConfig());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(cluster);
        long podCount = ((PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabel("imply.io/imply_node_type", this.implyNodeType.camelCasedName())).withLabel("app.kubernetes.io/instance", releaseName)).list()).getItems().stream().count();
        if (podCount > 0L) {
            this.toolbox.getNotificationDataManager().insert(Notification.of((String)String.format("[Await %d/%d] %d pods are still running for %s", this.getInfo().getUpdateState().getCurrentStageNumber(), this.getInfo().getUpdateState().getTotalStageCount(), podCount, this.getImplyNodeType().camelCasedName()), null, (Notification.Level)Notification.Level.INFO, (Notification.Source)Notification.Source.MANAGER, (String)this.getInfo().getKey()));
            return false;
        }
        return true;
    }

    @JsonProperty
    public ImplyNodeType getImplyNodeType() {
        return this.implyNodeType;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for [%s] pods to be terminated", this.implyNodeType.camelCasedName());
    }
}

