/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.KubernetesUtils;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ISE;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.Period;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitKubernetesDeploymentUpdatedStage
extends BaseStage {
    private final K8sUtilsProvider k8sUtilsProvider;
    private final ImplyNodeType implyNodeType;
    private final ServiceType serviceType;

    public OnPremAwaitKubernetesDeploymentUpdatedStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType) {
        this(toolbox, k8sUtilsProvider, clusterId, implyNodeType, null);
    }

    @JsonCreator
    public OnPremAwaitKubernetesDeploymentUpdatedStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType, @JsonProperty(value="serviceType") ServiceType serviceType) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.implyNodeType = implyNodeType;
        this.serviceType = serviceType;
    }

    public boolean innerRun() {
        List<ClusterOperationResult> results = this.getClusterOperationResults();
        if (results.size() != 1) {
            throw new ISE("Found [%d] deployments for imply node type [%s], must be exactly 1", new Object[]{results.size(), this.getImplyNodeType().camelCasedName()});
        }
        ClusterOperationResult result = results.get(0);
        if (ClusterOperationResult.Status.FAILED.equals((Object)result.getStatus())) {
            throw new RuntimeException(result.getMessage());
        }
        this.toolbox.getNotificationDataManager().insert(Notification.of((String)String.format("[Await %d/%d] %s", this.getInfo().getUpdateState().getCurrentStageNumber(), this.getInfo().getUpdateState().getTotalStageCount(), result.getMessage()), null, (Notification.Level)Notification.Level.INFO, (Notification.Source)Notification.Source.MANAGER, (String)this.getInfo().getKey()));
        return ClusterOperationResult.Status.COMPLETE.equals((Object)result.getStatus());
    }

    private List<ClusterOperationResult> getClusterOperationResults() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.toolbox.getApplicationConfig());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(cluster);
        KubernetesUtils utils = this.k8sUtilsProvider.getKubernetesUtils(cluster);
        if (this.getImplyNodeType().isDataType()) {
            FilterWatchListDeletable statefulset = (FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.apps().statefulSets().inNamespace(namespace)).withLabel("imply.io/imply_node_type", this.getImplyNodeType().camelCasedName())).withLabel("app.kubernetes.io/instance", releaseName);
            statefulset = this.getServiceType() != null ? (FilterWatchListDeletable)statefulset.withLabel("imply.io/imply_service_type", this.serviceType.getName()) : (FilterWatchListDeletable)statefulset.withoutLabel("imply.io/imply_service_type");
            return ((StatefulSetList)statefulset.list()).getItems().stream().map(s -> utils.getStatefulSetStatus((StatefulSet)s)).collect(Collectors.toList());
        }
        FilterWatchListDeletable deployment = (FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withLabel("imply.io/imply_node_type", this.getImplyNodeType().camelCasedName())).withLabel("app.kubernetes.io/instance", releaseName);
        deployment = this.getServiceType() != null ? (FilterWatchListDeletable)deployment.withLabel("imply.io/imply_service_type", this.serviceType.getName()) : (FilterWatchListDeletable)deployment.withoutLabel("imply.io/imply_service_type");
        return ((DeploymentList)deployment.list()).getItems().stream().map(d -> utils.getDeploymentStatus((Deployment)d)).collect(Collectors.toList());
    }

    @JsonProperty
    public ImplyNodeType getImplyNodeType() {
        return this.implyNodeType;
    }

    @JsonProperty
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for deployment manifests for [%s%s] to rollout", this.getImplyNodeType().camelCasedName(), this.serviceType == null ? "" : String.format("/%s", this.getServiceType().getName()));
    }

    public Integer getCompletionTimeoutInMinutes() {
        return new Period((Object)"P3D").toStandardMinutes().getMinutes();
    }
}

