/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.Toolbox;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.AwaitAgentReplacementStage;
import io.imply.cloud.manager.util.StageGenerator;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.Stage;
import io.imply.cloud.onprem.stage.OnPremAwaitDataInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitMasterInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitQueryInstancesAvailableStage;
import io.imply.cloud.onprem.stage.creation.OnPremBecomeServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremFetchConfigBundleStage;
import io.imply.cloud.onprem.stage.creation.OnPremStopServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremWriteConfigServerRequestPayloadStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitAgentReplacementStage
extends AwaitAgentReplacementStage
implements OnPremHelpers,
StageGenerator {
    @Generated
    private static final Logger log = Logger.from(OnPremAwaitAgentReplacementStage.class);
    private static final int CATTLE_TIMEOUT_MINS = 5;
    private boolean generateStages = true;
    private final OnPremManagerToolbox onPremManagerToolbox;

    public OnPremAwaitAgentReplacementStage(OnPremManagerToolbox toolbox, String clusterId, String host) {
        this(toolbox, clusterId, host, null);
    }

    @JsonCreator
    public OnPremAwaitAgentReplacementStage(@JacksonInject OnPremManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="host") String host, @JsonProperty(value="replacement") String replacement) {
        super((ManagerToolbox)toolbox, clusterId, host, replacement);
        this.onPremManagerToolbox = toolbox;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().getOrNull(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get(cluster != null ? cluster.getAccountId() : "onprem");
        List groveNodes = this.toolbox.getGroveClient().getGroveNodes(account.getGroveServer(), true);
        ClusterNodes nodes = this.toolbox.getClusterNodesDataManager().get(this.getClusterId());
        Map nodeMap = nodes.getNodes();
        NodeConfiguration configuration = (NodeConfiguration)nodeMap.remove(this.getHost());
        if (configuration != null) {
            if (BooleanUtils.isTrue((Boolean)configuration.isCattle()) && this.getState().getStageStartTime().plusMinutes(5).isBeforeNow()) {
                this.generateStages = false;
                return true;
            }
            if (this.getReplacement() == null) {
                return false;
            }
            Optional<Node> possibleNode = groveNodes.stream().filter(x -> this.getReplacement().equals(x.getAddress())).findFirst();
            if (!possibleNode.isPresent()) {
                log.info("Host [%s] is not connected to grove", new Object[]{this.getReplacement()});
                return false;
            }
            Node node = possibleNode.get();
            if (!node.isOnline()) {
                log.info("Host [%s] is not online", new Object[]{this.getReplacement()});
                return false;
            }
            nodeMap.put(this.getReplacement(), configuration);
            nodes = this.toolbox.getClusterNodesDataManager().insert(nodes.cloner().withNodes(nodeMap).build(), "SYSTEM_AGENT", true, false);
            this.toolbox.getEntityStateDataManager().insert(cluster, Info.builder().withDeployedClusterNodesVersion(nodes.getVersion()).build());
        } else {
            log.info("Host [%s] is no longer registered, skipping replacement", new Object[]{this.getHost()});
            this.generateStages = false;
        }
        return true;
    }

    public List<Stage> generateStages() {
        if (!this.generateStages) {
            return Collections.emptyList();
        }
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get((String)ObjectUtils.getIfNull((Object)cluster.getAccountId(), (Object)"onprem"));
        ClusterNodes nodes = this.toolbox.getClusterNodesDataManager().get(this.getClusterId());
        NodeConfiguration configuration = (NodeConfiguration)nodes.getNodes().get(this.getReplacement());
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)new OnPremStopServicesStage(this.toolbox, this.getClusterId(), account.getGroveServer(), Collections.singletonList(this.getHost()))).add((Object)new OnPremWriteConfigServerRequestPayloadStage(this.toolbox, cluster.getClusterId(), configuration.getNodeTypes(), account.getGroveServer(), this.getReplacement(), cluster.getConfigServerKey())).add((Object)new OnPremFetchConfigBundleStage(this.onprem((Toolbox)this.toolbox), cluster.getClusterId(), account.getGroveServer(), (List<String>)ImmutableList.of((Object)this.getReplacement()))).add((Object)new OnPremBecomeServicesStage(this.onprem((Toolbox)this.toolbox), cluster.getClusterId(), account.getGroveServer(), (List<String>)ImmutableList.of((Object)this.getReplacement())));
        if (configuration.getNodeTypes().stream().anyMatch(ImplyNodeType::isDataType)) {
            builder.add((Object)new OnPremAwaitDataInstancesAvailableStage(this.onPremManagerToolbox, cluster.getClusterId(), ClusterNodesHelper.getSortedDataHosts((Map)nodes.getNodes()).size()));
        } else if (configuration.getNodeTypes().stream().anyMatch(arg_0 -> ((ImplyNodeType)ImplyNodeType.QUERY).equals(arg_0))) {
            builder.add((Object)new OnPremAwaitQueryInstancesAvailableStage(this.toolbox, cluster.getClusterId(), ClusterNodesHelper.getSortedQueryHosts((Map)nodes.getNodes()).size()));
        } else if (configuration.getNodeTypes().stream().anyMatch(arg_0 -> ((ImplyNodeType)ImplyNodeType.MASTER).equals(arg_0))) {
            builder.add((Object)new OnPremAwaitMasterInstancesAvailableStage(this.toolbox, cluster.getClusterId(), ClusterNodesHelper.getSortedMasterHosts((Map)nodes.getNodes()).size()));
        }
        return builder.build();
    }
}

