/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.KubernetesManifestUtils;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremApplyKubernetesManifestsStage
extends BaseStage {
    @Generated
    private static final Logger log = Logger.from(OnPremApplyKubernetesManifestsStage.class);
    private final K8sUtilsProvider k8sUtilsProvider;
    private final KubernetesManifestUtils kubernetesManifestUtils;
    private final ImplyNodeType implyNodeType;
    private final Boolean orphanDeleteDeploymentBeforeApply;
    private final ServiceType serviceType;

    public OnPremApplyKubernetesManifestsStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JacksonInject KubernetesManifestUtils kubernetesManifestUtils, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType, @JsonProperty(value="orphanDeleteDeploymentBeforeApply") Boolean orphanDeleteDeploymentBeforeApply) {
        this(toolbox, k8sUtilsProvider, kubernetesManifestUtils, clusterId, implyNodeType, orphanDeleteDeploymentBeforeApply, null);
    }

    @JsonCreator
    public OnPremApplyKubernetesManifestsStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JacksonInject KubernetesManifestUtils kubernetesManifestUtils, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType, @JsonProperty(value="orphanDeleteDeploymentBeforeApply") Boolean orphanDeleteDeploymentBeforeApply, @JsonProperty(value="serviceType") ServiceType serviceType) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.kubernetesManifestUtils = kubernetesManifestUtils;
        this.implyNodeType = implyNodeType;
        this.orphanDeleteDeploymentBeforeApply = orphanDeleteDeploymentBeforeApply;
        this.serviceType = serviceType;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get(cluster.getAccountId());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(cluster);
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        List<HasMetadata> allManifests = this.kubernetesManifestUtils.generateManifests(cluster, account);
        List<HasMetadata> nodeTypeManifests = this.kubernetesManifestUtils.filterManifestsByType(allManifests, this.implyNodeType, this.serviceType);
        Map<Boolean, List<HasMetadata>> partitioned = nodeTypeManifests.stream().collect(Collectors.partitioningBy(m -> m instanceof Deployment || m instanceof StatefulSet));
        List<HasMetadata> deploymentManifests = partitioned.get(true);
        List<HasMetadata> nonDeploymentManifests = partitioned.get(false);
        log.info("Applying non-deployment manifests for [%s]", new Object[]{this.implyNodeType});
        ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList(nonDeploymentManifests).inNamespace(namespace)).createOrReplace();
        if (deploymentManifests.size() == 0) {
            return true;
        }
        if (this.orphanDeleteDeploymentBeforeApply.booleanValue()) {
            log.info("Orphan deleting deployment manifests for [%s]", new Object[]{this.implyNodeType});
            try {
                ((GracePeriodConfigurable)((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList(deploymentManifests).inNamespace(namespace)).withPropagationPolicy(DeletionPropagation.ORPHAN)).delete();
            }
            catch (KubernetesClientException e) {
                if (Response.Status.NOT_FOUND.getStatusCode() != e.getCode()) {
                    throw e;
                }
                log.warn("Unable to find deployment manifests for [%s] while deleting, assuming the manifest was already deleted.", new Object[]{this.implyNodeType});
            }
        }
        log.info("Applying deployment manifests for [%s]", new Object[]{this.implyNodeType});
        if (this.orphanDeleteDeploymentBeforeApply.booleanValue()) {
            Retryable.of(() -> (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList((Collection)deploymentManifests).inNamespace(namespace)).create(), (int)5, (int)5, (boolean)true);
        } else {
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList(deploymentManifests).inNamespace(namespace)).createOrReplace();
        }
        return true;
    }

    @JsonProperty
    public ImplyNodeType getImplyNodeType() {
        return this.implyNodeType;
    }

    @JsonProperty
    public Boolean getOrphanDeleteDeploymentBeforeApply() {
        return this.orphanDeleteDeploymentBeforeApply;
    }

    @JsonProperty
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty
    public String getDescription() {
        if (ImplyNodeType.UNKNOWN.equals((Object)this.implyNodeType)) {
            return "Applying manifests for [common]";
        }
        return String.format("Applying manifests for [%s%s]%s", this.implyNodeType.camelCasedName(), this.serviceType == null ? "" : String.format("/%s", this.getServiceType().getName()), this.orphanDeleteDeploymentBeforeApply != false ? " after orphan delete" : "");
    }
}

