/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremApplyHelmStage
extends BaseStage {
    private final ClusterOperator clusterOperator;

    @JsonCreator
    public OnPremApplyHelmStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject ClusterOperator clusterOperator, @JsonProperty(value="clusterId") String clusterId) {
        super((ManagerToolbox)toolbox, clusterId);
        this.clusterOperator = clusterOperator;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get(cluster.getAccountId());
        this.clusterOperator.updateCluster(cluster, account);
        ClusterOperationResult result = this.clusterOperator.getClusterOperationStatus(cluster, this.getInfo().getState());
        if (result.getStatus().equals((Object)ClusterOperationResult.Status.FAILED)) {
            throw new RuntimeException(result.getMessage());
        }
        return true;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Upgrading helm chart values", new Object[0]);
    }
}

