/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.operations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.Toolbox;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.CreateClusterAction;
import io.imply.cloud.manager.notice.cluster.ReloadNodeNotice;
import io.imply.cloud.manager.notice.operations.CheckGroveAgentsNotice;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.State;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.ListUtils;

@Singleton
public class OnPremCheckGroveAgentsNotice
extends CheckGroveAgentsNotice
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremCheckGroveAgentsNotice.class);
    private Map<String, Pair<String, StateMismatch>> stateMismatches = new HashMap<String, Pair<String, StateMismatch>>();
    private static final int AUTO_START_AGENT_VERSION = 10;
    private static final Pattern AGENT_VERSION_PATTERN = Pattern.compile("^v(\\d+)(?:-.+)?");

    @Inject
    public OnPremCheckGroveAgentsNotice(ManagerToolbox toolbox) {
        super(toolbox);
    }

    public void innerHandle() {
        this.stateMismatches.clear();
        List accounts = this.toolbox.getAccountDataManager().getAll(DeletedVisibility.HIDE);
        for (Account account : accounts) {
            Info info = this.toolbox.getEntityStateDataManager().get(account.getAccountId());
            if (!State.CREATED.equals((Object)info.getState().getExternalState(null))) {
                log.debug("Skipping check for account not in created state [%s]", new Object[]{account.getAccountId()});
                continue;
            }
            try {
                this.checkAccountGroveAgents(account);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Throwable)e, "Skipping availability check");
                    continue;
                }
                log.warn("Skipping availability check: [%s]", new Object[]{e.getMessage()});
            }
        }
    }

    public void checkAccountGroveAgents(Account account) {
        if (ListUtils.emptyIfNull((List)account.getFeatureFlags()).contains("disableGroveServer")) {
            log.debug("Skipping check for account [%s], grove server is disabled", new Object[]{account.getAccountId()});
            return;
        }
        HashMap<String, Node> groveNodes = new HashMap<String, Node>();
        try {
            groveNodes.putAll(this.toolbox.getGroveClient().getGroveNodes(account.getGroveServer(), false).stream().collect(Collectors.toMap(Node::getAddress, x -> x)));
        }
        catch (Exception e) {
            throw new ISE("Failed to get list of nodes from Grove server for account [%s]: %s", new Object[]{account.getAccountId(), e.getMessage()});
        }
        Map<String, Pair<String, NodeConfiguration>> assignedNodes = this.clusterNodesListAsMap(account.getAccountId());
        HashMap<String, List<Pair<String, Set<ImplyNodeType>>>> clustersToProcess = new HashMap<String, List<Pair<String, Set<ImplyNodeType>>>>();
        HashMap<String, String> nodesToReload = new HashMap<String, String>();
        HashSet<String> nodesToReap = new HashSet<String>();
        this.findTaggedNodesToAdd(groveNodes, assignedNodes, clustersToProcess, nodesToReload);
        this.findTaggedNodesToRemove(groveNodes, assignedNodes, clustersToProcess, nodesToReap);
        this.findTaggedNodesToReap(groveNodes, assignedNodes, nodesToReap);
        this.checkTaggedNodesAreAssignedToClusters(clustersToProcess);
        this.checkNodesAreOnlineForStartingOrRunningClusters(account.getAccountId(), groveNodes, nodesToReload);
        if (this.toolbox.getApplicationConfig().isKubernetesMode()) {
            this.removeAutoStartNodes(groveNodes, nodesToReload);
        }
        if (nodesToReap.size() > 0) {
            try {
                this.toolbox.getGroveClient().reap(account.getGroveServer(), (List)Lists.newArrayList(nodesToReap));
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Throwable)e, "Failed to reap offline nodes from Grove server; skipping reaping");
                }
                log.warn("Failed to reap offline nodes from Grove server; skipping reaping: %s", new Object[]{e.getMessage()});
            }
        }
        this.queueReloadNotices(nodesToReload);
    }

    public Map<String, Pair<String, StateMismatch>> getStateMismatches() {
        return this.stateMismatches;
    }

    @VisibleForTesting
    void removeAutoStartNodes(Map<String, Node> groveNodes, Map<String, String> nodesToReload) {
        groveNodes.entrySet().stream().forEach(e -> {
            if (Strings.isNullOrEmpty((String)((Node)e.getValue()).getAgentVersion())) {
                return;
            }
            Matcher agentVersionMatcher = AGENT_VERSION_PATTERN.matcher(((Node)e.getValue()).getAgentVersion());
            if (!agentVersionMatcher.matches()) {
                return;
            }
            int agentVersion = Integer.parseInt(agentVersionMatcher.group(1));
            if (agentVersion >= 10) {
                nodesToReload.remove(e.getKey());
            }
        });
    }

    private Map<String, Pair<String, NodeConfiguration>> clusterNodesListAsMap(String accountId) {
        HashMap<String, Pair<String, NodeConfiguration>> assignedNodes = new HashMap<String, Pair<String, NodeConfiguration>>();
        List clusters = this.toolbox.getClusterDataManager().getAllWithAccountId(accountId);
        List clusterNodess = clusters.stream().map(cluster -> this.toolbox.getClusterNodesDataManager().getOrNull(cluster.getClusterId())).filter(Objects::nonNull).collect(Collectors.toList());
        for (ClusterNodes clusterNodes : clusterNodess) {
            if (clusterNodes.getNodes() == null) continue;
            for (Map.Entry node : clusterNodes.getNodes().entrySet()) {
                assignedNodes.put((String)node.getKey(), (Pair<String, NodeConfiguration>)Pair.of((Object)clusterNodes.getClusterId(), (Object)(node.getValue() == null ? NodeConfiguration.empty() : (NodeConfiguration)node.getValue())));
            }
        }
        return assignedNodes;
    }

    private void checkTaggedNodesAreAssignedToClusters(Map<String, List<Pair<String, Set<ImplyNodeType>>>> clustersToProcess) {
        for (Map.Entry<String, List<Pair<String, Set<ImplyNodeType>>>> entry : clustersToProcess.entrySet()) {
            String clusterId = entry.getKey();
            ClusterNodes clusterNodes = this.toolbox.getClusterNodesDataManager().getOrNull(clusterId);
            if (clusterNodes == null) {
                if (this.toolbox.getClusterDataManager().isDeleted(clusterId)) {
                    log.warn("Nodes cannot be added to deleted clusterId [%s]", new Object[]{clusterId});
                    continue;
                }
                log.info("Tagged clusterId [%s] does not exist; creating new default cluster", new Object[]{clusterId});
                if (!this.createNewDefaultCluster(clusterId)) continue;
                clusterNodes = this.toolbox.getClusterNodesDataManager().getOrNull(clusterId);
            }
            HashMap<String, NodeConfiguration> nodes = clusterNodes.getNodes() != null ? new HashMap<String, NodeConfiguration>(clusterNodes.getNodes()) : new HashMap();
            log.debug("Node list for cluster [%s] pre-changes: %s", new Object[]{clusterId, nodes});
            for (Pair<String, Set<ImplyNodeType>> pair : entry.getValue()) {
                if (pair.rhs == null || ((Set)pair.rhs).isEmpty()) {
                    nodes.remove(pair.lhs);
                    continue;
                }
                nodes.put((String)pair.lhs, new NodeConfiguration((Set)pair.rhs, Boolean.valueOf(true)));
            }
            log.debug("Node list for cluster [%s] post-changes: %s", new Object[]{clusterId, nodes});
            this.toolbox.getClusterNodesDataManager().insertWithInfo(clusterNodes.cloner().withNodes(nodes).build(), this.toolbox.getEntityStateDataManager().getOrNull(clusterNodes.getClusterId()), "SYSTEM", true, true, true);
        }
    }

    private void findTaggedNodesToAdd(Map<String, Node> groveNodes, Map<String, Pair<String, NodeConfiguration>> assignedNodes, Map<String, List<Pair<String, Set<ImplyNodeType>>>> clustersToProcess, Map<String, String> nodesToReload) {
        for (Node node : groveNodes.values()) {
            if (!node.isOnline()) continue;
            String address = node.getAddress();
            String taggedClusterId = node.getTaggedClusterId();
            Set taggedNodeTypes = node.getTaggedImplyNodeTypes();
            if (address == null || taggedClusterId == null || taggedNodeTypes.isEmpty()) continue;
            if (assignedNodes.containsKey(address)) {
                if (taggedClusterId.equals(assignedNodes.get((Object)address).lhs)) {
                    if (taggedNodeTypes.equals(((NodeConfiguration)assignedNodes.get((Object)address).rhs).getNodeTypes())) continue;
                    this.stateMismatches.put(address, (Pair<String, StateMismatch>)Pair.of((Object)taggedClusterId, (Object)((Object)StateMismatch.ONLINE_TAGGED_AGENT_ASSIGNED_TO_UNEXPECTED_NODETYPE)));
                    log.warn("Node [%s] is in correct cluster [%s] but has different nodeTypes %s (expecting: %s), reassigning", new Object[]{address, taggedClusterId, ((NodeConfiguration)assignedNodes.get((Object)address).rhs).getNodeTypes(), taggedNodeTypes});
                } else {
                    this.stateMismatches.put(address, (Pair<String, StateMismatch>)Pair.of((Object)taggedClusterId, (Object)((Object)StateMismatch.ONLINE_TAGGED_AGENT_ASSIGNED_TO_UNEXPECTED_CLUSTER)));
                    log.warn("Node [%s] is tagged for cluster [%s] but is assigned to cluster [%s], reassigning", new Object[]{address, taggedClusterId, assignedNodes.get((Object)address).lhs});
                    clustersToProcess.computeIfAbsent((String)assignedNodes.get((Object)address).lhs, x -> new ArrayList());
                    clustersToProcess.get(assignedNodes.get((Object)address).lhs).add((Pair<String, Set<ImplyNodeType>>)Pair.of((Object)address, (Object)ImmutableSet.of()));
                }
                nodesToReload.put(address, taggedClusterId);
            }
            log.info("Assigning node [%s] to cluster [%s] as nodeTypes %s", new Object[]{address, taggedClusterId, taggedNodeTypes});
            clustersToProcess.computeIfAbsent(taggedClusterId, x -> new ArrayList());
            clustersToProcess.get(taggedClusterId).add((Pair<String, Set<ImplyNodeType>>)Pair.of((Object)address, (Object)taggedNodeTypes));
        }
    }

    private void findTaggedNodesToRemove(Map<String, Node> groveNodes, Map<String, Pair<String, NodeConfiguration>> assignedNodes, Map<String, List<Pair<String, Set<ImplyNodeType>>>> clustersToProcess, Set<String> nodesToReap) {
        for (Map.Entry<String, Pair<String, NodeConfiguration>> entry : assignedNodes.entrySet()) {
            NodeConfiguration nc;
            Node groveNode = groveNodes.get(entry.getKey());
            if (groveNode != null && (groveNode.isOnline() || groveNode.getLastHeartbeat() != null && groveNode.getLastHeartbeat().plusSeconds(60).isAfterNow()) || (nc = (NodeConfiguration)entry.getValue().rhs) == null || nc.isCattle() == null || !nc.isCattle().booleanValue()) continue;
            log.info("Node [%s] in cluster [%s] is no longer online; removing from cluster's node list", new Object[]{entry.getKey(), entry.getValue().lhs});
            clustersToProcess.computeIfAbsent((String)entry.getValue().lhs, x -> new ArrayList());
            clustersToProcess.get(entry.getValue().lhs).add((Pair<String, Set<ImplyNodeType>>)Pair.of((Object)entry.getKey(), (Object)ImmutableSet.of()));
            nodesToReap.add(entry.getKey());
        }
    }

    private void findTaggedNodesToReap(Map<String, Node> groveNodes, Map<String, Pair<String, NodeConfiguration>> assignedNodes, Set<String> nodesToReap) {
        for (Map.Entry<String, Node> entry : groveNodes.entrySet()) {
            Pair<String, NodeConfiguration> ncPair;
            Node groveNode = entry.getValue();
            if (groveNode != null && (groveNode.isOnline() || groveNode.getLastHeartbeat() != null && groveNode.getLastHeartbeat().plusHours(12).isAfterNow()) || (ncPair = assignedNodes.get(entry.getKey())) != null && (ncPair.rhs == null || ((NodeConfiguration)ncPair.rhs).isCattle() == null || !((NodeConfiguration)ncPair.rhs).isCattle().booleanValue())) continue;
            log.info("Node [%s] is no longer online or assigned to a cluster; reaping it from grove", new Object[]{entry.getKey()});
            nodesToReap.add(entry.getKey());
        }
    }

    private void checkNodesAreOnlineForStartingOrRunningClusters(String accountId, Map<String, Node> groveNodes, Map<String, String> nodesToReload) {
        List clusters = this.toolbox.getClusterDataManager().getAllWithAccountId(accountId);
        for (Cluster cluster : clusters) {
            Info info;
            if (FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.IMMUTABLE_CONTAINERS, (RefreshableConstants)this.toolbox.getRefreshableConstants()) || (info = this.toolbox.getEntityStateDataManager().getOrNull(cluster)) == null || info.getState() == null || !info.getState().isRunning() && !info.getState().isCreatingStartingOrUpdating()) continue;
            List hosts = this.onprem((Toolbox)this.toolbox).getClusterNodesHelper().getSortedHosts(cluster.getClusterId());
            for (String host : hosts) {
                Node node = groveNodes.get(host);
                if (node == null) {
                    this.stateMismatches.put(host, (Pair<String, StateMismatch>)Pair.of((Object)cluster.getClusterId(), (Object)((Object)StateMismatch.MISSING_AGENT_IN_RUNNING_CLUSTER)));
                    log.warn("Node [%s] in running cluster [%s] is not being reported by Grove server", new Object[]{host, cluster.getClusterId()});
                    continue;
                }
                if (!node.isOnline()) {
                    this.stateMismatches.put(host, (Pair<String, StateMismatch>)Pair.of((Object)cluster.getClusterId(), (Object)((Object)StateMismatch.OFFLINE_AGENT_IN_RUNNING_CLUSTER)));
                    log.warn("Node [%s] in running cluster [%s] is offline", new Object[]{host, cluster.getClusterId()});
                    continue;
                }
                if (node.isImplyRunning()) continue;
                this.stateMismatches.put(host, (Pair<String, StateMismatch>)Pair.of((Object)cluster.getClusterId(), (Object)((Object)StateMismatch.ONLINE_AGENT_NOT_RUNNING_IMPLY_IN_RUNNING_CLUSTER)));
                log.info("Node [%s] in running cluster [%s] is online but not running the Imply service; re-launching node", new Object[]{host, cluster.getClusterId()});
                nodesToReload.put(host, cluster.getClusterId());
            }
        }
    }

    private void queueReloadNotices(Map<String, String> nodesToReload) {
        for (Map.Entry<String, String> entry : nodesToReload.entrySet()) {
            log.info("Queuing ReloadNodeNotice for node [%s] in cluster [%s]", new Object[]{entry.getKey(), entry.getValue()});
            Info info = this.toolbox.getEntityStateDataManager().getOrNull(entry.getValue());
            this.toolbox.getNoticeManager().queueNotice(ReloadNodeNotice.class, info, (Map)ImmutableMap.of((Object)"nodeAddress", (Object)entry.getKey(), (Object)"useFailureCooldown", (Object)true), false);
        }
    }

    private boolean createNewDefaultCluster(String clusterId) {
        if (!this.toolbox.getRefreshableConstants().isReadyToCreateCluster()) {
            log.info("Waiting for configurations to load before creating cluster [%s]", new Object[]{clusterId});
            return false;
        }
        Cluster defaultCluster = this.toolbox.getInfoRouteManager().getDefaultsAndSupportedValues("onprem").getDefaultClusterSpec().cloner().withAccountId("onprem").withClusterId(clusterId).withName(clusterId).build();
        if (defaultCluster.getImplyVersion() == null) {
            log.warn("No default Imply version found, unable to create cluster [%s] (will retry)", new Object[]{clusterId});
            return false;
        }
        log.info("Creating new default cluster [%s]", new Object[]{defaultCluster});
        new CreateClusterAction(this.toolbox, defaultCluster, Boolean.valueOf(true), null, "SYSTEM").innerPerform();
        return true;
    }

    public static enum StateMismatch {
        MISSING_AGENT_IN_RUNNING_CLUSTER,
        OFFLINE_AGENT_IN_RUNNING_CLUSTER,
        ONLINE_AGENT_NOT_RUNNING_IMPLY_IN_RUNNING_CLUSTER,
        ONLINE_AGENT_RUNNING_UNEXPECTED_NODETYPE_IN_RUNNING_CLUSTER,
        ONLINE_AGENT_RUNNING_IMPLY_IN_STOPPED_CLUSTER,
        ONLINE_TAGGED_AGENT_ASSIGNED_TO_UNEXPECTED_CLUSTER,
        ONLINE_TAGGED_AGENT_ASSIGNED_TO_UNEXPECTED_NODETYPE;

    }
}

