/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.PreStartNotice;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.onprem.model.OnPremInfo;
import io.imply.cloud.onprem.stage.creation.OnPremMaybeCreateMetadataDatabaseStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import lombok.Generated;
import org.joda.time.DateTime;

public class OnPremPreStartNotice
extends PreStartNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremPreStartNotice.class);
    private OnPremManagerToolbox onPremManagerToolbox;

    @Inject
    public OnPremPreStartNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.onPremManagerToolbox = toolbox;
    }

    public void innerHandle() {
        if (!this.onPremManagerToolbox.getOnPremManagerConfig().isSkipClusterMetadataStoreCheck()) {
            log.info("Creating database");
            if (new OnPremMaybeCreateMetadataDatabaseStage(this.toolbox, this.info.getEntityId()).innerRun()) {
                log.info("Successfully created database for cluster [%s]", new Object[]{this.info.getEntityId()});
            } else {
                throw new ISE("Unable to create database for cluster [%s]", new Object[]{this.info.getEntityId()});
            }
        }
        this.entityStateDataManager.insert(this.info, (Info)((OnPremInfo.Builder)((OnPremInfo.Builder)OnPremInfo.builder().withState(State.CREATE_CLUSTER_STACK)).withNotificationCutoff(DateTime.now())).build());
        this.setQueueNextNotice();
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected State getExceptionState() {
        return State.CLUSTER_START_FAILED;
    }
}

