/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.PlanClusterCreationNotice;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.stage.OnPremAwaitDataInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitMasterInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitQueryInstancesAvailableStage;
import io.imply.cloud.onprem.stage.creation.OnPremBecomeServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremCheckZooKeeperStage;
import io.imply.cloud.onprem.stage.creation.OnPremFetchConfigBundleStage;
import io.imply.cloud.onprem.stage.creation.OnPremMaybeCreateMetadataDatabaseStage;
import io.imply.cloud.onprem.stage.creation.OnPremWriteConfigServerRequestPayloadStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OnPremPlanClusterCreationNotice
extends PlanClusterCreationNotice
implements OnPremHelpers {
    private final OnPremManagerToolbox onPremManagerToolbox;
    private final ClusterDataManager clusterDataManager;

    @Inject
    public OnPremPlanClusterCreationNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.onPremManagerToolbox = toolbox;
        this.clusterDataManager = toolbox.getClusterDataManager();
    }

    public void innerHandle() {
        OnPremCluster cluster = this.onprem(this.clusterDataManager.get(this.info.getEntityId()));
        ClusterNodes clusterNodes = this.toolbox.getClusterNodesDataManager().getOrNull(cluster.getClusterId());
        this.addInfoNotification("Planning cluster creation", new Object[0]);
        cluster = this.onPremManagerToolbox.getOnPremClusterSecurityHelper().maybeUpdateSecurity(cluster, x$0 -> this.addInfoNotification((String)x$0, new Object[0]));
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_STAGED_CREATION_IN_PROGRESS).withUpdateState(this.generateCreationStages(cluster, clusterNodes)).withConfigServerClusterVersion(cluster.getVersion()).build());
        this.addInfoNotification("Submitting cluster creation plan for execution", new Object[0]);
        this.setQueueNextNotice();
    }

    private UpdateState generateCreationStages(OnPremCluster cluster, ClusterNodes clusterNodes) {
        String groveServer = this.onprem(this.toolbox.getAccountDataManager().get(cluster.getAccountId())).getGroveServer();
        ArrayDeque<Object> creationPlan = new ArrayDeque<Object>();
        if (!this.onPremManagerToolbox.getOnPremManagerConfig().isSkipClusterMetadataStoreCheck()) {
            creationPlan.add(new OnPremMaybeCreateMetadataDatabaseStage(this.toolbox, cluster.getClusterId()));
        }
        if (!this.onPremManagerToolbox.getOnPremManagerConfig().isSkipClusterZkCheck()) {
            creationPlan.add(new OnPremCheckZooKeeperStage(this.toolbox, cluster.getClusterId()));
        }
        if (clusterNodes != null && clusterNodes.getNodes() != null && !clusterNodes.getNodes().isEmpty()) {
            Map<String, NodeConfiguration> nodes = clusterNodes.getNodes().entrySet().stream().filter(x -> x.getValue() != null && ((NodeConfiguration)x.getValue()).getNodeTypes() != null && !((NodeConfiguration)x.getValue()).getNodeTypes().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (Map.Entry<String, NodeConfiguration> entry : nodes.entrySet()) {
                Set nodeTypes = entry.getValue().getNodeTypes();
                creationPlan.add(new OnPremWriteConfigServerRequestPayloadStage(this.toolbox, cluster.getClusterId(), nodeTypes, groveServer, entry.getKey(), cluster.getConfigServerKey()));
            }
            ArrayList<String> hosts = new ArrayList<String>(nodes.keySet());
            List hostChunks = Lists.partition(hosts, (int)10);
            for (List hostChunk : hostChunks) {
                creationPlan.add(new OnPremFetchConfigBundleStage(this.onPremManagerToolbox, cluster.getClusterId(), groveServer, hostChunk));
                creationPlan.add(new OnPremBecomeServicesStage(this.onPremManagerToolbox, cluster.getClusterId(), groveServer, hostChunk));
            }
            if (!this.toolbox.getManagerConfig().isSkipClusterReadyValidation().booleanValue()) {
                creationPlan.add(new OnPremAwaitMasterInstancesAvailableStage(this.toolbox, cluster.getClusterId(), ClusterNodesHelper.getSortedMasterHosts(nodes).size()));
                creationPlan.add(new OnPremAwaitDataInstancesAvailableStage(this.onPremManagerToolbox, cluster.getClusterId(), ClusterNodesHelper.getSortedDataHosts(nodes).size()));
                creationPlan.add(new OnPremAwaitQueryInstancesAvailableStage(this.toolbox, cluster.getClusterId(), ClusterNodesHelper.getSortedQueryHosts(nodes).size()));
            }
        }
        this.toolbox.getStageHelper().tagWithStageNumbers(creationPlan, 1);
        UpdateState.Builder updateStateBuilder = UpdateState.builder((UpdateState)this.info.getUpdateState()).pendingRollingStages(creationPlan).completedRollingStages(new ArrayDeque()).currentState(State.CLUSTER_STAGED_CREATION_IN_PROGRESS).clearTimerAndCounters();
        return updateStateBuilder.build();
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected State getExceptionState() {
        return State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION;
    }

    protected Status getFailureStatus() {
        return Status.WARNING;
    }
}

