/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.notice.cluster.OnPremPostUpdateNotice;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import lombok.Generated;

public class OnPremKubernetesPostUpdateNotice
extends OnPremPostUpdateNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesPostUpdateNotice.class);
    protected final K8sUtilsProvider k8sUtilsProvider;

    @Inject
    public OnPremKubernetesPostUpdateNotice(OnPremManagerToolbox toolbox, K8sUtilsProvider k8sUtilsProvider) {
        super(toolbox);
        this.k8sUtilsProvider = k8sUtilsProvider;
    }

    @Override
    protected void innerHandle() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId());
        ApplicationConfig applicationConfig = this.toolbox.getApplicationConfig();
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, applicationConfig);
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, applicationConfig);
        try {
            log.info("Attempting to delete unused PVCs for cluster [%s]", new Object[]{cluster.getClusterId()});
            this.k8sUtilsProvider.getKubernetesUtils(cluster).deleteUnusedPVCsForRelease(namespace, releaseName);
        }
        catch (Exception e) {
            log.warn("Failed to delete unused PVCs for cluster [%s], message: '%s'", new Object[]{cluster.getClusterId(), e.getMessage()});
        }
        super.innerHandle();
    }
}

