/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.GetClusterStackDeletionStatusNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import lombok.Generated;

public class OnPremKubernetesGetClusterStackDeletionStatusNotice
extends GetClusterStackDeletionStatusNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesGetClusterStackDeletionStatusNotice.class);
    private final ClusterDataManager clusterDataManager;
    private final ClusterOperator clusterOperator;

    @Inject
    public OnPremKubernetesGetClusterStackDeletionStatusNotice(OnPremManagerToolbox toolbox, ClusterOperator clusterOperator) {
        super((ManagerToolbox)toolbox);
        this.clusterDataManager = toolbox.getClusterDataManager();
        this.clusterOperator = clusterOperator;
    }

    public void innerHandle() {
        String clusterId = this.info.getEntityId();
        OnPremCluster cluster = this.onprem(this.clusterDataManager.getOrNull(clusterId));
        if (cluster == null) {
            this.addInfoNotification("Deleting cluster [%s]. Cluster not found. Assuming already deleted", new Object[]{clusterId});
            log.info("Deleting cluster [%s]. Cluster not found. Assuming already deleted", new Object[]{clusterId});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_STACK_DELETED).build());
            return;
        }
        ClusterOperationResult clusterOperationResult = this.clusterOperator.getClusterOperationStatus((Cluster)cluster, this.info.getState());
        switch (clusterOperationResult.getStatus()) {
            case FAILED: {
                this.addCriticalNotification("Failed to delete cluster [%s]. %s", new Object[]{clusterId, clusterOperationResult.getMessage()});
                log.error("Failed to delete cluster [%s]. %s", new Object[]{clusterId, clusterOperationResult.getMessage()});
                this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getFailureState()).build());
                break;
            }
            case PENDING: {
                this.addInfoNotification("Deleting cluster [%s]. %s", new Object[]{clusterId, clusterOperationResult.getMessage()});
                break;
            }
            case COMPLETE: {
                this.addInfoNotification("Successfully deleted cluster [%s].", new Object[]{clusterId});
                log.info("Successfully deleted cluster [%s].", new Object[]{clusterId});
                this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_STACK_DELETED).build());
                this.setQueueNextNotice();
            }
        }
    }

    protected State getTimeoutState() {
        return this.getFailureState();
    }

    protected Status getFailureStatus() {
        return Status.CRITICAL;
    }

    @VisibleForTesting
    State getFailureState() {
        return State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION;
    }
}

